/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.reporters;

import com.codahale.metrics.health.HealthCheck;
import com.google.gson.Gson;
import io.tsdb.services.framework.common.configuration.ServiceInfo;
import io.tsdb.services.framework.common.instrumentation.reporters.HealthcheckResultSerializer;
import io.tsdb.services.framework.common.instrumentation.reporters.HealthcheckResultStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HealthcheckResult
implements Serializable {
    private final List<String> handlers = new ArrayList<String>();
    private final Map<String, String> tags = new HashMap<String, String>();
    private String name;
    private String output;
    private HealthcheckResultStatus status = HealthcheckResultStatus.OK;

    public HealthcheckResult(String name, String output) {
        this(name, output, HealthcheckResultStatus.UNKNOWN);
    }

    public HealthcheckResult(String name, HealthCheck.Result healthCheckResult) {
        this.setName(name);
        this.setOutput(healthCheckResult.getMessage());
        if (healthCheckResult.isHealthy()) {
            this.setStatus(HealthcheckResultStatus.OK);
        } else {
            this.setStatus(HealthcheckResultStatus.CRITICAL);
        }
    }

    private HealthcheckResult(String name, String output, HealthcheckResultStatus status) {
        this.setName(name);
        this.setOutput(output);
        this.setStatus(status);
        this.setDefaultHandlers();
        this.setDefaultTags();
    }

    private void setDefaultTags() {
        this.addTag("servicename", ServiceInfo.serviceName);
        this.addTag("processname", ServiceInfo.processName);
        this.addTag("hostname", ServiceInfo.getHostString());
        this.addTag("adminport", String.valueOf(ServiceInfo.adminPort));
        this.addTag("adminpath", ServiceInfo.adminPath);
    }

    private void setDefaultHandlers() {
        this.addHandler("notification-standard");
    }

    public HealthcheckResultStatus getStatus() {
        return this.status;
    }

    public void setStatus(HealthcheckResultStatus status) {
        this.status = status;
    }

    public int getStatusValue() {
        return this.status.getValue();
    }

    public String getOutput() {
        return this.output;
    }

    private void setOutput(String output) {
        this.output = output;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public void addHandler(String handler) {
        this.handlers.add(handler);
    }

    public void addTag(String tagk, String tagv) {
        this.tags.put(tagk, tagv);
    }

    public String toString(boolean pretty) {
        Gson gson = HealthcheckResultSerializer.gsonMetricInfoFactory(pretty);
        return gson.toJson((Object)this);
    }
}

