/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.metricsets;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OperatingSystemMetricSet
implements MetricSet {
    private final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        gauges.put("load.average", (Metric)new Gauge<Double>(){

            public Double getValue() {
                return OperatingSystemMetricSet.this.os.getSystemLoadAverage();
            }
        });
        gauges.put("cpu.num_available", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return OperatingSystemMetricSet.this.os.getAvailableProcessors();
            }
        });
        this.addDoubleIfExists(gauges, "cpu.usage", "getSystemCpuLoad");
        this.addDoubleIfExists(gauges, "cpu.process.usage", "getProcessCpuLoad");
        this.addLongIfExists(gauges, "cpu.process.ns", "getProcessCpuTime()");
        this.addLongIfExists(gauges, "mem.committed", "getCommittedVirtualMemorySize");
        this.addLongIfExists(gauges, "mem.free", "getFreePhysicalMemorySize");
        this.addLongIfExists(gauges, "mem.size", "getTotalPhysicalMemorySize");
        this.addLongIfExists(gauges, "swap.free", "getFreeSwapSpaceSize");
        this.addLongIfExists(gauges, "swap.size", "getTotalSwapSpaceSize");
        this.addLongIfExists(gauges, "file.descriptors.max", "getMaxFileDescriptorCount");
        this.addLongIfExists(gauges, "file.descriptors.open", "getOpenFileDescriptorCount");
        return Collections.unmodifiableMap(gauges);
    }

    private void addLongIfExists(Map<String, Metric> gauges, String metricName, final String beanFuncName) {
        long val = this.invokeLong(beanFuncName, -1L);
        if (val != -1L) {
            gauges.put(metricName, (Metric)new Gauge<Long>(){

                public Long getValue() {
                    return OperatingSystemMetricSet.this.invokeLong(beanFuncName, -1L);
                }
            });
        }
    }

    private void addDoubleIfExists(Map<String, Metric> gauges, String metricName, final String beanFuncName) {
        double val = this.invokeDouble(beanFuncName, -1.0);
        if (val != -1.0) {
            gauges.put(metricName, (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return OperatingSystemMetricSet.this.invokeDouble(beanFuncName, -1.0);
                }
            });
        }
    }

    private long invokeLong(String name, long dflt) {
        try {
            Method method = this.os.getClass().getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return (Long)method.invoke((Object)this.os, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return dflt;
        }
    }

    private double invokeDouble(String name, double dflt) {
        try {
            Method method = this.os.getClass().getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return (Double)method.invoke((Object)this.os, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return dflt;
        }
    }
}

