/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.configuration;

import io.tsdb.services.framework.common.configuration.ConfigurationReader;
import io.tsdb.services.framework.common.instrumentation.Metrics;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class ServiceInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    public static final String processName = ManagementFactory.getRuntimeMXBean().getName();
    public static final Long pid = Long.parseLong(processName.split("@")[0]);
    public static String serviceName;
    public static int mainPort;
    public static String mainPath;
    public static String endpointPackage;
    public static String providersPackage;
    public static int adminPort;
    public static String adminPath;

    private static void initializeLog4jBridge() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getLogger("global").setLevel(Level.FINEST);
    }

    public static String getHostString() {
        String hostname;
        if (ConfigurationReader.hasProperty("service.hostname")) {
            hostname = ConfigurationReader.getProperty("service.hostname");
        } else {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = ServiceInfo.getMachineIP();
            }
        }
        return hostname;
    }

    public static String getMachineIP() {
        try {
            String hostIP = InetAddress.getLocalHost().getHostAddress();
            if (!hostIP.equals("127.0.0.1")) {
                return hostIP;
            }
            Enumeration<NetworkInterface> nInterfaces = NetworkInterface.getNetworkInterfaces();
            while (nInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> inetAddresses = nInterfaces.nextElement().getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    String address = inetAddresses.nextElement().getHostAddress();
                    if (address.equals("127.0.0.1")) continue;
                    return address;
                }
            }
        }
        catch (SocketException | UnknownHostException e1) {
            LOGGER.error(e1.getMessage());
        }
        return "127.0.0.1";
    }

    static {
        ServiceInfo.initializeLog4jBridge();
        LOGGER.info("ProcessName: " + processName);
        MDC.put((String)"processname", (String)processName);
        MDC.put((String)"servicename", (String)serviceName);
        serviceName = ConfigurationReader.getProperty("service.name", System.getProperty("serviceName", "datamanager"));
        mainPort = ConfigurationReader.getIntegerProperty(serviceName + ".main.port", 8080);
        mainPath = ConfigurationReader.getProperty(serviceName + ".main.path", System.getProperty("mainPath", "/" + serviceName));
        endpointPackage = ConfigurationReader.getProperty(serviceName + ".main.endpointpackage", System.getProperty("mainPath", "io.tsdb.services." + serviceName + ".rest"));
        providersPackage = ConfigurationReader.getProperty(serviceName + ".main.providerspackage", System.getProperty("mainPath", "io.tsdb.services." + serviceName + ".providers"));
        adminPort = ConfigurationReader.getIntegerProperty(serviceName + ".admin.port", 8081);
        adminPath = ConfigurationReader.getProperty(serviceName + ".admin.path", System.getProperty("adminPath", "/admin"));
    }
}

