/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.metricsets;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileSystemMetricSet
implements MetricSet {
    private final FileSystem fileSystems;
    private final boolean skipZeroAvail;

    public FileSystemMetricSet() {
        this.fileSystems = FileSystems.getDefault();
        this.skipZeroAvail = true;
    }

    public FileSystemMetricSet(FileSystem fs, boolean skipZeroAvail) {
        this.fileSystems = fs;
        this.skipZeroAvail = skipZeroAvail;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        for (final FileStore store : this.fileSystems.getFileStores()) {
            try {
                if (this.skipZeroAvail && store.getUsableSpace() == 0L) {
                }
            }
            catch (IOException e) {}
            continue;
            String fsName = this.getFSName(store);
            gauges.put("fs." + fsName + ".total_bytes", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return store.getTotalSpace();
                    }
                    catch (IOException e) {
                        return -1L;
                    }
                }
            });
            gauges.put("fs." + fsName + ".used_bytes", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return store.getTotalSpace() - store.getUnallocatedSpace();
                    }
                    catch (IOException e) {
                        return -1L;
                    }
                }
            });
            gauges.put("fs." + fsName + ".free_bytes", new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return store.getUsableSpace();
                    }
                    catch (IOException e) {
                        return -1L;
                    }
                }
            });
            gauges.put("fs." + fsName + ".used_pc", new Gauge<Double>(){

                public Double getValue() {
                    try {
                        return (1.0 - (double)store.getUnallocatedSpace() / (double)store.getTotalSpace()) * 100.0;
                    }
                    catch (IOException e) {
                        return -1.0;
                    }
                }
            });
            gauges.put("fs." + fsName + ".free_pc", new Gauge<Double>(){

                public Double getValue() {
                    try {
                        return (double)store.getUnallocatedSpace() / (double)store.getTotalSpace() * 100.0;
                    }
                    catch (IOException e) {
                        return -1.0;
                    }
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }

    private String getFSName(FileStore store) {
        return this.getFSNameByToStringPath(store);
    }

    public String getFSNameByName(FileStore store) {
        return store.name().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    private String getFSNameByToStringPath(FileStore store) {
        String path;
        try {
            path = store.toString().split(" ", 2)[0];
        }
        catch (Exception e) {
            path = store.toString();
        }
        if (path.equals("/")) {
            return "root";
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path.replaceAll("[^a-zA-Z0-9_]", "_");
    }
}

