/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.configuration;

import com.codahale.metrics.MetricRegistry;
import com.google.common.net.HostAndPort;
import io.tsdb.services.framework.common.instrumentation.configuration.MetricsConfigurationInterface;
import java.net.InetSocketAddress;

public abstract class MetricsConfigurationAbstract
implements MetricsConfigurationInterface {
    private String metricRoot = "metrics";
    private String metricPrefix = "generic.localhost.0";
    private int metricReportingInterval = 5;
    private int healthReportingInterval = 60;
    private int metricLoggingInterval = 60;
    private int healthLoggingInterval = 60;
    private HostAndPort metricReportingTarget = HostAndPort.fromParts((String)"localhost", (int)2003);
    private HostAndPort healthReportingTarget = HostAndPort.fromParts((String)"localhost", (int)3001);

    @Override
    public String getMetricRoot() {
        return this.metricRoot;
    }

    @Override
    public void setMetricRoot(String metricRoot) {
        this.metricRoot = metricRoot;
    }

    @Override
    public String getMetricPrefix() {
        return this.metricPrefix;
    }

    @Override
    public void setMetricPrefix(String metricPrefix) {
        this.metricPrefix = metricPrefix;
    }

    @Override
    public String getMetricNamespace() {
        return MetricRegistry.name((String)this.getMetricRoot(), (String[])new String[]{this.getMetricPrefix()});
    }

    @Override
    public int getMetricReportingInterval() {
        return this.metricReportingInterval;
    }

    @Override
    public void setMetricReportingInterval(int metricReportingInterval) {
        this.metricReportingInterval = metricReportingInterval;
    }

    @Override
    public int getHealthReportingInterval() {
        return this.healthReportingInterval;
    }

    @Override
    public void setHealthReportingInterval(int healthReportingInterval) {
        this.healthReportingInterval = healthReportingInterval;
    }

    @Override
    public int getMetricLoggingInterval() {
        return this.metricLoggingInterval;
    }

    @Override
    public void setMetricLoggingInterval(int metricLoggingInterval) {
        this.metricLoggingInterval = metricLoggingInterval;
    }

    @Override
    public int getHealthLoggingInterval() {
        return this.healthLoggingInterval;
    }

    @Override
    public void setHealthLoggingInterval(int healthLoggingInterval) {
        this.healthLoggingInterval = healthLoggingInterval;
    }

    @Override
    public HostAndPort getMetricReportingTarget() {
        return this.metricReportingTarget;
    }

    @Override
    public InetSocketAddress getMetricReportingAddress() {
        return new InetSocketAddress(this.metricReportingTarget.getHost(), this.metricReportingTarget.getPort());
    }

    @Override
    public String getMetricReportingHost() {
        return this.metricReportingTarget.getHost();
    }

    @Override
    public int getMetricReportingPort() {
        return this.metricReportingTarget.getPort();
    }

    @Override
    public void setMetricReportingTarget(HostAndPort metricReportingTarget) {
        this.metricReportingTarget = metricReportingTarget;
    }

    @Override
    public void setMetricReportingTarget(String metricReportingHost, int metricReportingPort) {
        this.metricReportingTarget = HostAndPort.fromParts((String)metricReportingHost, (int)metricReportingPort);
    }

    @Override
    public HostAndPort getHealthReportingTarget() {
        return this.healthReportingTarget;
    }

    @Override
    public InetSocketAddress getHealthReportingAddress() {
        return new InetSocketAddress(this.healthReportingTarget.getHost(), this.healthReportingTarget.getPort());
    }

    @Override
    public String getHealthReportingHost() {
        return this.healthReportingTarget.getHost();
    }

    @Override
    public int getHealthReportingPort() {
        return this.healthReportingTarget.getPort();
    }

    @Override
    public void setHealthReportingTarget(HostAndPort metricReportingTarget) {
        this.healthReportingTarget = metricReportingTarget;
    }

    @Override
    public void setHealthReportingTarget(String metricReportingHost, int metricReportingPort) {
        this.healthReportingTarget = HostAndPort.fromParts((String)metricReportingHost, (int)metricReportingPort);
    }
}

