/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.configuration;

import io.tsdb.services.framework.common.configuration.ConfigurationSource;
import io.tsdb.services.framework.common.configuration.PropertyNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSourceImpl
implements ConfigurationSource {
    protected Configuration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSource.class);

    @Override
    public String getProperty(String property) throws PropertyNotFoundException {
        if (!this.configuration.containsKey(property)) {
            throw new PropertyNotFoundException();
        }
        return this.configuration.getProperty(property).toString();
    }

    @Override
    public String getProperty(String property, String defaultValue) {
        try {
            if (this.configuration.containsKey(property)) {
                return this.configuration.getProperty(property).toString();
            }
            return defaultValue;
        }
        catch (Exception e) {
            LOGGER.warn("Exception getting configuration value: " + e.getMessage());
            return defaultValue;
        }
    }

    @Override
    public String updateProperty(String property, String value) {
        this.configuration.setProperty(property, (Object)value);
        return this.getProperty(property, value);
    }

    @Override
    public Boolean hasProperty(String property) {
        return this.configuration.containsKey(property);
    }

    @Override
    public List<String> getProperties() {
        return ConfigurationSourceImpl.getProperties(this.configuration.getKeys());
    }

    public static List<String> getProperties(Iterator<String> keys) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        while (keys.hasNext()) {
            propertiesList.add(keys.next());
        }
        return propertiesList;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

