/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.logback.InstrumentedAppender;
import com.google.common.net.HostAndPort;
import io.tsdb.services.framework.common.instrumentation.configuration.DefaultMetricsConfiguration;
import io.tsdb.services.framework.common.instrumentation.metricsets.FileSystemMetricSet;
import io.tsdb.services.framework.common.instrumentation.metricsets.OperatingSystemMetricSet;
import io.tsdb.services.framework.common.instrumentation.metricsets.RuntimeMetricSet;
import io.tsdb.services.framework.common.instrumentation.reporters.Log4jHealthcheckReporter;
import io.tsdb.services.framework.common.instrumentation.reporters.SensuHealthcheckReporter;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private static final DefaultMetricsConfiguration METRICS_CONFIGURATION = new DefaultMetricsConfiguration();
    private static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();
    private static final HealthCheckRegistry HEALTH_CHECK_REGISTRY = new HealthCheckRegistry();

    private static void startReport() {
        Log4jHealthcheckReporter logReporter;
        if (METRICS_CONFIGURATION.getMetricReportingInterval() > 0) {
            Graphite graphite = new Graphite(METRICS_CONFIGURATION.getMetricReportingAddress());
            GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)Metrics.getMetricRegistry()).prefixedWith(METRICS_CONFIGURATION.getMetricNamespace()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
            graphiteReporter.start((long)METRICS_CONFIGURATION.getMetricReportingInterval(), TimeUnit.SECONDS);
        }
        if (METRICS_CONFIGURATION.getMetricLoggingInterval() > 0) {
            logReporter = Slf4jReporter.forRegistry((MetricRegistry)Metrics.getMetricRegistry()).outputTo(LoggerFactory.getLogger((String)METRICS_CONFIGURATION.getMetricNamespace())).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            logReporter.start(METRICS_CONFIGURATION.getMetricLoggingInterval(), TimeUnit.SECONDS);
        }
        if (METRICS_CONFIGURATION.getHealthLoggingInterval() > 0) {
            logReporter = new Log4jHealthcheckReporter(METRICS_CONFIGURATION.getHealthLoggingInterval());
        }
        if (METRICS_CONFIGURATION.getHealthReportingInterval() > 0) {
            HostAndPort healthReportingAddress = METRICS_CONFIGURATION.getHealthReportingTarget();
            SensuHealthcheckReporter sensuHealthcheckReporter = new SensuHealthcheckReporter(METRICS_CONFIGURATION.getHealthReportingInterval(), healthReportingAddress);
        }
    }

    private static void registerAll(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                Metrics.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public static void initialize() {
        Metrics.startReport();
    }

    public static void registerMetricSet(String prefix, MetricSet metricSet) {
        Metrics.registerAll(prefix, metricSet, Metrics.getMetricRegistry());
    }

    public static void registerHealthCheck(String name, HealthCheck healthcheck) {
        Metrics.getHealthCheckRegistry().register(name, healthcheck);
    }

    public static Counter getCounter(Class<?> originatingClass, String ... names) {
        return Metrics.getCounter(MetricRegistry.name(originatingClass, (String[])names));
    }

    private static Counter getCounter(String name) {
        return METRIC_REGISTRY.counter(name);
    }

    public static Timer getTimer(Class<?> originatingClass, String ... names) {
        return Metrics.getTimer(MetricRegistry.name(originatingClass, (String[])names));
    }

    private static Timer getTimer(String name) {
        return METRIC_REGISTRY.timer(name);
    }

    public static Meter getMeter(Class<?> originatingClass, String ... names) {
        return Metrics.getMeter(MetricRegistry.name(originatingClass, (String[])names));
    }

    private static Meter getMeter(String name) {
        return METRIC_REGISTRY.meter(name);
    }

    public static void incCounter(Class<?> originatingClass, String ... names) {
        String name = MetricRegistry.name(originatingClass, (String[])names);
        Counter counter = Metrics.getCounter(name);
        counter.inc();
    }

    public static void decCounter(Class<?> originatingClass, String ... names) {
        String name = MetricRegistry.name(originatingClass, (String[])names);
        Counter counter = Metrics.getCounter(name);
        counter.dec();
    }

    public static void markMeter(Class<?> originatingClass, String ... names) {
        String name = MetricRegistry.name(originatingClass, (String[])names);
        Meter meter = Metrics.getMeter(name);
        meter.mark();
    }

    public static Timer.Context getTimerContext(Class<?> originatingClass, String ... names) {
        String name = MetricRegistry.name(originatingClass, (String[])names);
        Timer timer = Metrics.getTimer(name);
        return timer.time();
    }

    public void startTimer(Class<?> originatingClass, String ... names) {
        Metrics.getTimerContext(originatingClass, names);
    }

    public void stopTimer(Class<?> originatingClass, String ... names) {
        Timer.Context timerContext = Metrics.getTimerContext(originatingClass, names);
        timerContext.stop();
    }

    public static MetricRegistry getMetricRegistry() {
        return METRIC_REGISTRY;
    }

    public static HealthCheckRegistry getHealthCheckRegistry() {
        return HEALTH_CHECK_REGISTRY;
    }

    static {
        Metrics.registerMetricSet("jvm.gc", (MetricSet)new GarbageCollectorMetricSet());
        Metrics.registerMetricSet("jvm.memory", (MetricSet)new MemoryUsageGaugeSet());
        Metrics.registerMetricSet("jvm.threads", (MetricSet)new ThreadStatesGaugeSet());
        Metrics.registerMetricSet("jvm.runtime", new RuntimeMetricSet());
        Metrics.registerMetricSet("jvm.os", new OperatingSystemMetricSet());
        Metrics.registerMetricSet("jvm.filesystem", new FileSystemMetricSet());
        Metrics.registerAll("jvm.buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()), Metrics.getMetricRegistry());
        Metrics.registerHealthCheck("DeadlockDetection", (HealthCheck)new ThreadDeadlockHealthCheck());
        LoggerContext factory = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = factory.getLogger("ROOT");
        InstrumentedAppender instrumentedAppender = new InstrumentedAppender(Metrics.getMetricRegistry());
        instrumentedAppender.setContext((Context)root.getLoggerContext());
        instrumentedAppender.start();
        root.addAppender((Appender)instrumentedAppender);
    }
}

