/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.configuration;

import io.tsdb.services.framework.common.configuration.ConfigurationSourceImpl;
import io.tsdb.services.framework.common.configuration.EnvironmentConfiguration;
import io.tsdb.services.framework.common.configuration.PropertiesConfiguration;
import java.util.List;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReader.class);
    private static final CombinedConfiguration COMBINED_CONFIGURATION = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
    static final EnvironmentConfiguration ENVIRONMENT_CONFIGURATION = new EnvironmentConfiguration();
    private static final String CONFIG = ENVIRONMENT_CONFIGURATION.getProperty("config", "environment.properties");
    private static final boolean RELOADABLE = Boolean.parseBoolean(ENVIRONMENT_CONFIGURATION.getProperty("config.reloadable", "false"));

    private ConfigurationReader() {
    }

    public static synchronized void loadPropertiesFile(String fileName) {
        ConfigurationReader.loadPropertiesFile(fileName, RELOADABLE);
    }

    private static synchronized void loadPropertiesFile(String fileName, boolean makeReloadable) {
        LOGGER.debug("Loading Configuration File: {}", (Object)fileName);
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(fileName, makeReloadable);
        if (propertiesConfiguration.getConfiguration() != null) {
            LOGGER.debug("Successfully loaded {}", (Object)fileName);
            try {
                LOGGER.debug("Adding resulting configuraiton to the Combined Configuration");
                COMBINED_CONFIGURATION.addConfiguration(propertiesConfiguration.getConfiguration());
                LOGGER.debug("Success");
            }
            catch (Exception e) {
                LOGGER.warn("Could not load properties file: {}", (Object)fileName);
                LOGGER.debug("Could not load properties file", (Throwable)e);
            }
        }
    }

    public static synchronized String updateProperty(String property, String value) {
        COMBINED_CONFIGURATION.setProperty(property, (Object)value);
        return ConfigurationReader.getProperty(property, value);
    }

    public static String getProperty(String property) {
        String value;
        LOGGER.debug("getProperty: {}", (Object)property);
        try {
            value = COMBINED_CONFIGURATION.getString(property);
        }
        catch (Exception e) {
            value = COMBINED_CONFIGURATION.getString(property);
        }
        LOGGER.debug("Value: {}", (Object)value);
        return value;
    }

    public static boolean hasProperty(String property) {
        return COMBINED_CONFIGURATION.containsKey(property);
    }

    public static String getProperty(String property, String defaultValue) {
        String value;
        LOGGER.debug("getProperty: {}", (Object)property);
        LOGGER.debug("hasProperty: {}", (Object)COMBINED_CONFIGURATION.containsKey(property));
        try {
            value = COMBINED_CONFIGURATION.getString(property, defaultValue);
        }
        catch (Exception e) {
            value = COMBINED_CONFIGURATION.getString(property, defaultValue);
        }
        LOGGER.debug("Value: {}", (Object)value);
        return value;
    }

    public static Boolean getBooleanProperty(String property, Boolean defaultValue) {
        String value = ConfigurationReader.getProperty(property, defaultValue.toString());
        return Boolean.parseBoolean(value);
    }

    public static int getIntegerProperty(String property, int defaultValue) {
        String value = ConfigurationReader.getProperty(property, String.valueOf(defaultValue));
        return Integer.parseInt(value);
    }

    public static long getLongProperty(String property, long defaultValue) {
        Long retValue = defaultValue;
        String value = ConfigurationReader.getProperty(property, String.valueOf(defaultValue));
        try {
            if (value != null) {
                retValue = Long.parseLong(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retValue;
    }

    public static List<String> getProperties() {
        return ConfigurationSourceImpl.getProperties(COMBINED_CONFIGURATION.getKeys());
    }

    static {
        COMBINED_CONFIGURATION.addConfiguration(ENVIRONMENT_CONFIGURATION.getConfiguration());
        ConfigurationReader.loadPropertiesFile(CONFIG, RELOADABLE);
        ConfigurationReader.loadPropertiesFile("resources/application.properties", RELOADABLE);
    }
}

