/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.core.listeners;

import io.tromba.testdriver.core.TestdriverManager;
import io.tromba.testdriver.core.WebDriverFactory;
import io.tromba.testdriver.core.logging.BasicTestdriverLogger;
import io.tromba.testdriver.core.logging.EventLoggingWebDriver;
import io.tromba.testdriver.core.logging.LogLevel;
import io.tromba.testdriver.core.logging.TestdriverLogger;
import io.tromba.testdriver.utils.TestdriverConfig;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public class TestdriverListener
implements IInvokedMethodListener {
    private static final int MAX_WAIT;
    private TestdriverManager testdriverManager = new TestdriverManager();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            WebDriver driver = WebDriverFactory.createInstance();
            EventFiringWebDriver augmentedDriver = new EventFiringWebDriver(new Augmenter().augment(driver));
            TestdriverLogger logger = this.getLogger();
            EventLoggingWebDriver loggingWebDriver = new EventLoggingWebDriver(logger);
            augmentedDriver.register((WebDriverEventListener)loggingWebDriver);
            this.testdriverManager.setDriver(method.getTestMethod().getMethodName(), (WebDriver)augmentedDriver, logger);
            augmentedDriver.manage().timeouts().implicitlyWait((long)MAX_WAIT, TimeUnit.SECONDS);
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            String uuid = "";
            try {
                String key = method.getTestMethod().getMethodName();
                WebDriver driver = this.testdriverManager.getDriver(key);
                uuid = this.testdriverManager.getUuid(key);
                this.testdriverManager.destroyDriver(key);
                if (!method.getTestResult().isSuccess()) {
                    String screenshot = (String)((TakesScreenshot)driver).getScreenshotAs(OutputType.BASE64);
                    this.getLogger().log(LogLevel.INFO, screenshot);
                }
                driver.quit();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("An error occurred - Are you pointing to the correct Selenium Grid?\n" + e.getMessage());
            }
            finally {
                this.testdriverManager.destroyDriver(method.getTestMethod().getMethodName());
            }
        }
    }

    private TestdriverLogger getLogger() {
        return new BasicTestdriverLogger();
    }

    static {
        TestdriverConfig.getInstance();
        MAX_WAIT = Integer.valueOf(TestdriverConfig.getMaxImplicitWaitInSeconds());
    }
}

