/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.pages;

import io.tromba.testdriver.utils.TestdriverConfig;
import io.tromba.testdriver.utils.TestdriverWait;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPage {
    private static final int MAX_WAIT;
    protected WebDriver driver;
    protected TestdriverWait wait;

    public AbstractPage(WebDriver driver) {
        this.driver = driver;
        PageFactory.initElements((WebDriver)driver, (Object)this);
        this.wait = new TestdriverWait(driver, MAX_WAIT);
    }

    protected WebElement findByLinkText(String text) {
        return this.driver.findElement(By.linkText((String)text));
    }

    protected WebElement findByXpathAndText(String xpath, String text) {
        return this.driver.findElement(By.xpath((String)String.format(xpath, text)));
    }

    protected List<WebElement> findElementsByXpathAndText(String xpath, String text) {
        return this.driver.findElements(By.xpath((String)String.format(xpath, text)));
    }

    static {
        TestdriverConfig.getInstance();
        MAX_WAIT = Integer.parseInt(TestdriverConfig.getMaxWaitInSeconds());
    }
}

