/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.core;

import io.tromba.testdriver.core.TestEssential;
import io.tromba.testdriver.core.logging.TestdriverLogger;
import io.tromba.testdriver.exceptions.DriverNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestdriverManager {
    private static Map<String, TestEssential> testEssentials = new HashMap<String, TestEssential>();

    public synchronized void setDriver(String method, WebDriver driver, TestdriverLogger logger) {
        TestEssential testEssential = new TestEssential(driver, logger);
        testEssentials.put(this.generateKey(method), testEssential);
    }

    public WebDriver getDriver(String method) {
        return testEssentials.get(this.generateKey(method)).getDriver();
    }

    public String getUuid(String method) {
        return testEssentials.get(this.generateKey(method)).getUuid();
    }

    public synchronized void destroyDriver(String method) {
        testEssentials.get(this.generateKey(method)).getLogger().write();
        testEssentials.remove(method);
    }

    public Set<String> getDriverSet() {
        return testEssentials.keySet();
    }

    public WebDriver driver() {
        return this.getDriver(this.findMethod());
    }

    public TestdriverLogger logger() {
        return this.getLogger(this.findMethod());
    }

    private TestdriverLogger getLogger(String method) {
        return testEssentials.get(this.generateKey(method)).getLogger();
    }

    private String findMethod() {
        StackTraceElement[] stackTraceElements;
        Set<String> methods = this.getDriverSet();
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            if (!methods.contains(this.generateKey(methodName))) continue;
            return methodName;
        }
        throw new DriverNotFoundException();
    }

    private String generateKey(String method) {
        return method + Thread.currentThread().getId();
    }
}

