/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.core;

import io.tromba.testdriver.core.TestdriverManager;
import io.tromba.testdriver.core.listeners.TestdriverAnnotationTransformer;
import io.tromba.testdriver.core.listeners.TestdriverListener;
import io.tromba.testdriver.core.logging.LogLevel;
import io.tromba.testdriver.core.logging.TestdriverLogger;
import io.tromba.testdriver.environment.EnvironmentHandler;
import org.openqa.selenium.WebDriver;
import org.testng.Assert;
import org.testng.annotations.Listeners;

@Listeners(value={TestdriverListener.class, TestdriverAnnotationTransformer.class})
public class BaseTestdriverTest {
    private EnvironmentHandler environmentHandler;
    private TestdriverManager testdriverManager = new TestdriverManager();

    public BaseTestdriverTest() {
    }

    public BaseTestdriverTest(EnvironmentHandler environmentHandler) {
        this.environmentHandler = environmentHandler;
    }

    public WebDriver driver() {
        return this.testdriverManager.driver();
    }

    public TestdriverLogger logger() {
        return this.testdriverManager.logger();
    }

    public void assertTrue(boolean condition) {
        this.logger().log(LogLevel.ASSERTION, "Asserting that " + condition + " is true");
        Assert.assertTrue((boolean)condition);
    }

    public void assertEquals(String expected, String found) {
        this.logger().log(LogLevel.ASSERTION, "Asserting that " + expected + " equals " + found);
        Assert.assertEquals((String)expected, (String)found);
    }
}

