/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.utils;

import com.google.common.base.Function;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestdriverWait
extends WebDriverWait {
    public TestdriverWait(WebDriver driver, long timeOutInSeconds) {
        super(driver, timeOutInSeconds);
    }

    public void forElementVisible(WebElement element) {
        this.until((Function)ExpectedConditions.visibilityOf((WebElement)element));
    }

    public void forElementNotStale(final WebElement element) {
        this.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver webDriver) {
                try {
                    element.isDisplayed();
                    return true;
                }
                catch (StaleElementReferenceException ex) {
                    return false;
                }
            }
        });
    }

    private ExpectedCondition<Boolean> not(final ExpectedCondition<?> toInvert) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    Object result = toInvert.apply((Object)driver);
                    return result == null || result == Boolean.FALSE;
                }
                catch (Exception e) {
                    return true;
                }
            }
        };
    }

    @Deprecated
    public void sleep(int timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

