/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.core.listeners;

import io.tromba.testdriver.core.TestdriverManager;
import io.tromba.testdriver.core.WebDriverFactory;
import io.tromba.testdriver.utils.TestdriverConfig;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriver;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public class TestdriverListener
implements IInvokedMethodListener {
    private static final int MAX_WAIT;
    private TestdriverManager testdriverManager = new TestdriverManager();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            WebDriver driver = WebDriverFactory.createInstance();
            this.testdriverManager.setDriver(method.getTestMethod().getMethodName(), driver);
            driver.manage().timeouts().implicitlyWait((long)MAX_WAIT, TimeUnit.SECONDS);
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            try {
                String key = method.getTestMethod().getMethodName();
                WebDriver driver = this.testdriverManager.getDriver(key);
                this.testdriverManager.destroyDriver(key);
                driver.close();
                driver.quit();
            }
            catch (Exception e) {
                throw new RuntimeException("An error occurred - Are you pointing to the correct Selenium Grid? " + e.getMessage());
            }
            this.testdriverManager.destroyDriver(method.getTestMethod().getMethodName());
        }
    }

    static {
        TestdriverConfig.getInstance();
        MAX_WAIT = Integer.valueOf(TestdriverConfig.getMaxImplicitWaitInSeconds());
    }
}

