/*
 * Decompiled with CFR 0.152.
 */
package io.tromba.testdriver.core;

import io.tromba.testdriver.exceptions.DriverNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestdriverManager {
    private static Map<String, WebDriver> drivers = new HashMap<String, WebDriver>();

    public synchronized void setDriver(String method, WebDriver driver) {
        drivers.put(this.generateKey(method), driver);
    }

    public WebDriver getDriver(String method) {
        return drivers.get(this.generateKey(method));
    }

    public synchronized void destroyDriver(String method) {
        drivers.remove(method);
    }

    public Set<String> getDriverSet() {
        return drivers.keySet();
    }

    public WebDriver driver() {
        StackTraceElement[] stackTraceElements;
        Set<String> methods = this.getDriverSet();
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            if (!methods.contains(this.generateKey(methodName))) continue;
            return this.getDriver(methodName);
        }
        throw new DriverNotFoundException();
    }

    private String generateKey(String method) {
        return method + Thread.currentThread().getId();
    }
}

