/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.testhelper;

import java.lang.reflect.Field;

public final class FieldAccessUtil {
    private FieldAccessUtil() {
    }

    public static <T> T getFieldVal(Object obj, String fieldName) {
        Class<?> objClass = obj.getClass();
        return FieldAccessUtil.getFieldVal(obj, objClass, fieldName);
    }

    private static <T> T getFieldVal(Object obj, Class<?> objClass, String fieldName) {
        Field field = null;
        try {
            field = objClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object object = field.get(obj);
            return (T)object;
        }
        catch (NoSuchFieldException e) {
            if (objClass.getSuperclass() != null) {
                T t = FieldAccessUtil.getFieldVal(obj, objClass.getSuperclass(), fieldName);
                return t;
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }
}

