/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.testhelper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Mockito;

public final class DelegationTestUtil {
    private static final Set<String> BLACKLIST_METHOD = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("class$", "finalize", "equals", "hashCode", "toString", "clone", "newInstance")));

    public static <I, W> Delegation<I, W> assertDelegationToSpy(I innerObj) {
        return new Delegation(innerObj);
    }

    private static Object[] generateMockedParams(Method wrapperMethod) {
        Class<?>[] parameterTypes = wrapperMethod.getParameterTypes();
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Class<?> parameterType : parameterTypes) {
            if ("boolean".equals(parameterType.getName())) {
                arguments.add(Boolean.FALSE);
                continue;
            }
            if ("int".equals(parameterType.getName())) {
                arguments.add(0);
                continue;
            }
            if ("long".equals(parameterType.getName())) {
                arguments.add(0L);
                continue;
            }
            if (parameterType == String.class) {
                arguments.add("");
                continue;
            }
            arguments.add(Mockito.mock(parameterType));
        }
        return arguments.toArray(new Object[arguments.size()]);
    }

    private static String paramsToStr(Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        int parameterTypesLength = parameterTypes.length;
        for (int i = 0; i < parameterTypesLength; ++i) {
            Class<?> type = parameterTypes[i];
            sb.append(type.getName());
            if (i >= parameterTypesLength - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private DelegationTestUtil() {
    }

    public static class Delegation<I, W> {
        private final I innerObj;
        private W wrapperObj;
        private final Set<String> ignoreMethods = new HashSet<String>();

        Delegation(I innerObj) {
            this.innerObj = innerObj;
        }

        public Delegation<I, W> by(W wrapperObj) {
            this.wrapperObj = wrapperObj;
            return this;
        }

        public Delegation<I, W> ignore(String methodName) {
            this.ignoreMethods.add(methodName);
            return this;
        }

        public void verify() {
            if (!Mockito.mockingDetails(this.innerObj).isMock()) {
                throw new IllegalStateException("Inner object is no Mockito mock!");
            }
            if (Mockito.mockingDetails(this.wrapperObj).isMock()) {
                throw new IllegalStateException("Wrapper objecgt should be real class with mocked inner object inside");
            }
            String errorMsg = "";
            try {
                Method[] wrapperMethods = this.wrapperObj.getClass().getDeclaredMethods();
                HashMap<String, Method> innerMethods = new HashMap<String, Method>();
                for (Method innerMethod : this.innerObj.getClass().getDeclaredMethods()) {
                    if (!Modifier.isPublic(innerMethod.getModifiers())) continue;
                    innerMethods.put(innerMethod.getName() + " :: " + DelegationTestUtil.paramsToStr(innerMethod.getParameterTypes()), innerMethod);
                }
                for (Method wrapperMethod : wrapperMethods) {
                    if (!innerMethods.containsKey(wrapperMethod.getName() + " :: " + DelegationTestUtil.paramsToStr(wrapperMethod.getParameterTypes())) || BLACKLIST_METHOD.contains(wrapperMethod.getName()) || this.ignoreMethods.contains(wrapperMethod.getName())) continue;
                    errorMsg = "Method not delegated: " + wrapperMethod.getName();
                    Object[] arguments = DelegationTestUtil.generateMockedParams(wrapperMethod);
                    wrapperMethod.invoke(this.wrapperObj, arguments);
                    ((Method)innerMethods.get(wrapperMethod.getName() + " :: " + DelegationTestUtil.paramsToStr(wrapperMethod.getParameterTypes()))).invoke(Mockito.verify(this.innerObj), arguments);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(errorMsg + "\n" + e.getMessage(), e);
            }
        }
    }
}

