/*
 * Decompiled with CFR 0.152.
 */
package io.tracee;

import io.tracee.NoopTraceeLoggerFactory;
import io.tracee.PermitAllTraceeFilterConfiguration;
import io.tracee.TraceeBackend;
import io.tracee.TraceeLoggerFactory;
import io.tracee.configuration.TraceeFilterConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleTraceeBackend
implements TraceeBackend {
    private Map<String, String> valuesBeforeLastClear = Collections.emptyMap();
    private Map<String, String> backendValues = new HashMap<String, String>();
    private final TraceeFilterConfiguration configuration;
    private final TraceeLoggerFactory loggerFactory;

    public static SimpleTraceeBackend createNonLoggingAllPermittingBackend() {
        return new SimpleTraceeBackend(new PermitAllTraceeFilterConfiguration(), new NoopTraceeLoggerFactory());
    }

    public SimpleTraceeBackend(TraceeFilterConfiguration configuration, TraceeLoggerFactory loggerFactory) {
        this.configuration = configuration;
        this.loggerFactory = loggerFactory;
    }

    public TraceeFilterConfiguration getConfiguration(String profileName) {
        return this.configuration;
    }

    public TraceeFilterConfiguration getConfiguration() {
        return this.configuration;
    }

    public TraceeLoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public boolean containsKey(String key) {
        return this.backendValues.containsKey(key);
    }

    public String get(String key) {
        return this.backendValues.get(key);
    }

    public int size() {
        return this.backendValues.size();
    }

    public void clear() {
        this.valuesBeforeLastClear = new HashMap<String, String>(this.copyToMap());
        this.backendValues.clear();
    }

    public boolean isEmpty() {
        return this.backendValues.isEmpty();
    }

    public void put(String key, String value) {
        this.backendValues.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        this.backendValues.putAll(m);
    }

    public Map<String, String> copyToMap() {
        return new HashMap<String, String>(this.backendValues);
    }

    public void remove(String key) {
        this.backendValues.remove(key);
    }

    public String getInvocationId() {
        return this.get("TPIC.invocationId");
    }

    public String getSessionId() {
        return this.get("TPIC.sessionId");
    }

    public Map<String, String> getValuesBeforeLastClear() {
        return this.valuesBeforeLastClear;
    }
}

