/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.jms;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import java.lang.reflect.Method;
import java.util.Map;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jms.JMSException;
import javax.jms.Message;

public final class TraceeMessageListener {
    private final TraceeBackend backend;

    TraceeMessageListener(TraceeBackend backend) {
        this.backend = backend;
    }

    public TraceeMessageListener() {
        this(Tracee.getBackend());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        boolean isMdbInvocation = this.isMessageListenerOnMessageMethod(ctx.getMethod());
        try {
            if (isMdbInvocation) {
                this.beforeProcessing(this.extractMessageParameter(ctx.getParameters()));
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (isMdbInvocation) {
                this.cleanUp();
            }
        }
    }

    public void beforeProcessing(Message message) throws JMSException {
        Object encodedTraceeContext;
        if (this.backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.AsyncProcess) && (encodedTraceeContext = message.getObjectProperty("TPIC")) != null) {
            Map contextFromMessage = (Map)encodedTraceeContext;
            Map filteredContext = this.backend.getConfiguration().filterDeniedParams(contextFromMessage, TraceeFilterConfiguration.Channel.AsyncProcess);
            this.backend.putAll(filteredContext);
        }
    }

    void cleanUp() {
        if (this.backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.AsyncProcess)) {
            this.backend.clear();
        }
    }

    Message extractMessageParameter(Object[] parameters) {
        return (Message)parameters[0];
    }

    boolean isMessageListenerOnMessageMethod(Method method) {
        return "onMessage".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Message.class;
    }
}

