/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.jms.out;

import io.tracee.jms.out.TraceeMessageProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public final class TraceeTopicPublisher
implements TopicPublisher {
    private final TraceeMessageProducer messageProducer;
    private final TopicPublisher delegate;

    public TraceeTopicPublisher(TraceeMessageProducer messageProducer, TopicPublisher delegate) {
        this.messageProducer = messageProducer;
        this.delegate = delegate;
    }

    public Topic getTopic() throws JMSException {
        return this.delegate.getTopic();
    }

    public void publish(Message message) throws JMSException {
        this.messageProducer.writeTraceeContextToMessage(message);
        this.delegate.publish(message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.writeTraceeContextToMessage(message);
        this.delegate.publish(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.messageProducer.writeTraceeContextToMessage(message);
        this.delegate.publish(topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.writeTraceeContextToMessage(message);
        this.delegate.publish(topic, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message) throws JMSException {
        this.messageProducer.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.messageProducer.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.messageProducer.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.messageProducer.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.messageProducer.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.messageProducer.getDestination();
    }

    public void close() throws JMSException {
        this.messageProducer.close();
    }
}

