/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.jms.out;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public final class TraceeMessageProducer
implements MessageProducer {
    private final MessageProducer delegate;
    private final TraceeBackend backend;

    TraceeMessageProducer(MessageProducer delegate, TraceeBackend backend) {
        this.delegate = delegate;
        this.backend = backend;
    }

    public TraceeMessageProducer(MessageProducer delegate) {
        this.delegate = delegate;
        this.backend = Tracee.getBackend();
    }

    protected void writeTraceeContextToMessage(Message message) throws JMSException {
        if (!this.backend.isEmpty() && this.backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.AsyncDispatch)) {
            Map filteredContext = this.backend.getConfiguration().filterDeniedParams((Map)this.backend, TraceeFilterConfiguration.Channel.AsyncDispatch);
            message.setObjectProperty("X-TracEE-Context", (Object)filteredContext);
        }
    }

    public void send(Message message) throws JMSException {
        this.writeTraceeContextToMessage(message);
        this.delegate.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.writeTraceeContextToMessage(message);
        this.delegate.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.writeTraceeContextToMessage(message);
        this.delegate.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.writeTraceeContextToMessage(message);
        this.delegate.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.delegate.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.delegate.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.delegate.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.delegate.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.delegate.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.delegate.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.delegate.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.delegate.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.delegate.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.delegate.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.delegate.getDestination();
    }

    public void close() throws JMSException {
        this.delegate.close();
    }
}

