/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.outbound.httpcomponents;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpJsonHeaderTransport;
import io.tracee.transport.TransportSerialization;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class TraceeHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final TraceeBackend backend;
    private final TransportSerialization<String> transportSerialization;
    private final String profile;

    TraceeHttpResponseInterceptor(TraceeBackend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
        this.transportSerialization = new HttpJsonHeaderTransport(backend.getLoggerFactory());
    }

    public TraceeHttpResponseInterceptor() {
        this(null);
    }

    public TraceeHttpResponseInterceptor(String profile) {
        this(Tracee.getBackend(), profile);
    }

    public final void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        Header traceeHeader = response.getFirstHeader("X-TracEE-Context");
        if (traceeHeader != null && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingResponse)) {
            Map parsedContext = this.transportSerialization.parse((Object)traceeHeader.getValue());
            this.backend.putAll(filterConfiguration.filterDeniedParams(parsedContext, TraceeFilterConfiguration.Channel.IncomingResponse));
        }
    }
}

