/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.outbound.httpcomponents;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpJsonHeaderTransport;
import io.tracee.transport.TransportSerialization;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class TraceeHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final TraceeBackend backend;
    private final TransportSerialization<String> transportSerialization;
    private final String profile;

    public TraceeHttpRequestInterceptor() {
        this(null);
    }

    public TraceeHttpRequestInterceptor(String profile) {
        this(Tracee.getBackend(), profile);
    }

    TraceeHttpRequestInterceptor(TraceeBackend backend, String profile) {
        this.backend = backend;
        this.transportSerialization = new HttpJsonHeaderTransport(backend.getLoggerFactory());
        this.profile = profile;
    }

    public final void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingRequest)) {
            Map filteredParams = filterConfiguration.filterDeniedParams((Map)this.backend, TraceeFilterConfiguration.Channel.OutgoingRequest);
            String contextAsHeader = (String)this.transportSerialization.render(filteredParams);
            httpRequest.setHeader("X-TracEE-Context", contextAsHeader);
        }
    }
}

