/*
 * MIT License
 *
 * Copyright (c) 2022. Toxicity
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 **/
package io.toxicity.rsa.api.key.validator.ext

import io.toxicity.rsa.api.key.validator.RsaApiKeyMessage.Companion.UTC
import kotlinx.datetime.*
import kotlin.test.Test
import kotlin.test.assertFalse
import kotlin.test.assertTrue

class StringExtUnitTest {

    @Test
    fun givenFutureTime_whenCheckedForExpiration_thenReturnsFalse() {
        val futureInstant = Clock.System.now().plus(5_000, DateTimeUnit.MILLISECOND)
        val timeString = futureInstant.toRsaApiKeyFormat()

        assertFalse(timeString.isExpiredInternal())
    }

    @Test
    fun givenPastTime_whenCheckedForExpiration_thenReturnTrue() {
        val pastInstant = Clock.System.now().minus(5_000, DateTimeUnit.MILLISECOND)
        val timeString = pastInstant.toRsaApiKeyFormat()

        assertTrue(timeString.isExpiredInternal())
    }

    // Convert from Iso-8601 to the validator's format of "yyyy-MM-dd' 'HH:mm:ss' 'UTC"
    private fun Instant.toRsaApiKeyFormat(): String {
        val splits = toString().dropLast(1).split('T')
        return "${splits[0]} ${splits[1]} $UTC"
    }
}
