/*
 * MIT License
 *
 * Copyright (c) 2022. Toxicity
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 **/
package io.toxicity.rsa.api.key.validator.ext

import io.toxicity.rsa.api.key.validator.RsaApiKeyMessage.Companion.DATE_FORMAT
import io.toxicity.rsa.api.key.validator.RsaApiKeyMessage.Companion.EXPIRATION_NEVER
import io.toxicity.rsa.api.key.validator.RsaApiKeyMessage.Companion.UTC
import java.text.SimpleDateFormat
import java.util.*
import kotlin.jvm.JvmSynthetic
import kotlin.jvm.Throws

@JvmSynthetic
@Throws(Exception::class)
@Suppress("nothing_to_inline")
internal actual inline fun String.isExpiredInternal(): Boolean {
    if (this == EXPIRATION_NEVER) {
        return false
    }

    val tz = TimeZone.getTimeZone(UTC)

    val sdf = SimpleDateFormat(DATE_FORMAT, Locale.US)
    sdf.timeZone = tz

    val expiration = sdf.parse(this)
    val now = Calendar.getInstance(tz).time

    return expiration.before(now)
}
