/*
 * Decompiled with CFR 0.152.
 */
package io.toxicity.rsa.api.key.validator;

import io.matthewnelson.component.base64.Base64Kt;
import io.toxicity.rsa.api.key.validator.DevKeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage;", "", "isDevKey", "", "packageName", "", "type", "Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;", "expiration", "uuid", "(ZLjava/lang/String;Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;Ljava/lang/String;Ljava/lang/String;)V", "equals", "other", "hashCode", "", "isExpired", "toString", "Companion", "Type", "Validator", "rsa-api-key-validator"})
public final class RsaApiKeyMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final boolean isDevKey;
    @JvmField
    @NotNull
    public final String packageName;
    @JvmField
    @NotNull
    public final Type type;
    @JvmField
    @NotNull
    public final String expiration;
    @JvmField
    @NotNull
    public final String uuid;
    @NotNull
    public static final String ARG_IS_DEV_KEY = "isDevKey=";
    @NotNull
    public static final String ARG_PACKAGE_NAME = "packageName=";
    @NotNull
    public static final String ARG_TYPE = "type=";
    @NotNull
    public static final String ARG_EXPIRATION = "expiration=";
    @NotNull
    public static final String ARG_UUID = "uuid=";
    @NotNull
    public static final String EXPIRATION_NEVER = "NEVER";
    @NotNull
    public static final String UTC = "UTC";
    @NotNull
    public static final String DATE_FORMAT = "yyyy-MM-dd' 'HH:mm:ss' UTC'";

    private RsaApiKeyMessage(boolean isDevKey, String packageName, Type type, String expiration, String uuid) {
        this.isDevKey = isDevKey;
        this.packageName = packageName;
        this.type = type;
        this.expiration = expiration;
        this.uuid = uuid;
    }

    public final boolean isExpired() {
        boolean bl;
        String $this$isExpiredInternal$iv = this.expiration;
        boolean $i$f$isExpiredInternal = false;
        if (Intrinsics.areEqual((Object)$this$isExpiredInternal$iv, (Object)EXPIRATION_NEVER)) {
            bl = false;
        } else {
            TimeZone tz$iv = TimeZone.getTimeZone(UTC);
            SimpleDateFormat sdf$iv = new SimpleDateFormat(DATE_FORMAT, Locale.US);
            sdf$iv.setTimeZone(tz$iv);
            Date expiration$iv = sdf$iv.parse($this$isExpiredInternal$iv);
            Date now$iv = Calendar.getInstance(tz$iv).getTime();
            bl = expiration$iv.before(now$iv);
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RsaApiKeyMessage && ((RsaApiKeyMessage)other).isDevKey == this.isDevKey && Intrinsics.areEqual((Object)((RsaApiKeyMessage)other).packageName, (Object)this.packageName) && ((RsaApiKeyMessage)other).type == this.type && Intrinsics.areEqual((Object)((RsaApiKeyMessage)other).expiration, (Object)this.expiration) && Intrinsics.areEqual((Object)((RsaApiKeyMessage)other).uuid, (Object)this.uuid);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + Boolean.hashCode(this.isDevKey);
        result = result * 31 + this.packageName.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.expiration.hashCode();
        result = result * 31 + this.uuid.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n        RsaApiKeyMessage(\n            isDevKey=" + this.isDevKey + ",\n            packageName=" + this.packageName + ",\n            type=" + this.type + ",\n            expiration=" + this.expiration + ",\n            uuid=" + this.uuid + "\n        )\n    "));
    }

    @JvmStatic
    @NotNull
    public static final RsaApiKeyMessage fromString(@NotNull String message) throws IllegalArgumentException {
        return Companion.fromString(message);
    }

    public /* synthetic */ RsaApiKeyMessage(boolean isDevKey, String packageName, Type type, String expiration, String uuid, DefaultConstructorMarker $constructor_marker) {
        this(isDevKey, packageName, type, expiration, uuid);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;", "", "(Ljava/lang/String;I)V", "PUSH", "MESSAGE", "rsa-api-key-validator"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PUSH = new Type();
        public static final /* enum */ Type MESSAGE = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.PUSH, Type.MESSAGE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Companion;", "", "()V", "ARG_EXPIRATION", "", "ARG_IS_DEV_KEY", "ARG_PACKAGE_NAME", "ARG_TYPE", "ARG_UUID", "DATE_FORMAT", "EXPIRATION_NEVER", "UTC", "fromString", "Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage;", "message", "rsa-api-key-validator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RsaApiKeyMessage fromString(@NotNull String message) throws IllegalArgumentException {
            String uuidString;
            String string;
            Object object;
            Object object2;
            String packageName;
            boolean isDevKey;
            String it;
            List lines;
            block30: {
                block29: {
                    Type type;
                    String string2;
                    block28: {
                        block27: {
                            Boolean bl;
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            lines = StringsKt.lines((CharSequence)message);
                            String string3 = (String)CollectionsKt.getOrNull((List)lines, (int)0);
                            if (string3 != null) {
                                it = string3;
                                boolean bl2 = false;
                                bl = StringsKt.toBooleanStrictOrNull((String)StringsKt.substringAfter$default((String)it, (String)RsaApiKeyMessage.ARG_IS_DEV_KEY, null, (int)2, null));
                                if (bl == null) {
                                    throw new IllegalArgumentException("Failed to determine isDevKey= value from " + it);
                                }
                            } else {
                                throw new IllegalArgumentException("Failed to determine isDevKey= value");
                            }
                            isDevKey = bl;
                            String string4 = (String)CollectionsKt.getOrNull((List)lines, (int)1);
                            if (string4 == null) break block27;
                            String it2 = string4;
                            boolean bl3 = false;
                            String name = StringsKt.substringAfter$default((String)it2, (String)RsaApiKeyMessage.ARG_PACKAGE_NAME, null, (int)2, null);
                            if (!(((CharSequence)name).length() > 0)) {
                                boolean $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22 = false;
                                String $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22 = "Package name cannot be empty";
                                throw new IllegalArgumentException($i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22.toString());
                            }
                            string2 = name;
                            if (string2 != null) break block28;
                        }
                        throw new IllegalArgumentException("Failed to determine packageName= value");
                    }
                    packageName = string2;
                    string2 = (String)CollectionsKt.getOrNull((List)lines, (int)2);
                    if (string2 == null || (it = StringsKt.substringAfter$default((String)string2, (String)RsaApiKeyMessage.ARG_TYPE, null, (int)2, null)) == null) break block29;
                    String it3 = it;
                    boolean bl = false;
                    try {
                        type = Type.valueOf(it3);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to determine type= value from " + it3, e);
                    }
                    object2 = type;
                    if (object2 != null) break block30;
                }
                throw new IllegalArgumentException("Failed to determine type= value");
            }
            Type type = object2;
            it = (String)CollectionsKt.getOrNull((List)lines, (int)3);
            if (it != null && (object2 = StringsKt.substringAfter$default((String)it, (String)RsaApiKeyMessage.ARG_EXPIRATION, null, (int)2, null)) != null) {
                Object dateString = object2;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)dateString, (Object)RsaApiKeyMessage.EXPIRATION_NEVER)) {
                    object = dateString;
                } else {
                    Object $this$isExpiredInternal$iv;
                    try {
                        $this$isExpiredInternal$iv = dateString;
                        boolean $i$f$isExpiredInternal = false;
                        if (!Intrinsics.areEqual((Object)$this$isExpiredInternal$iv, (Object)RsaApiKeyMessage.EXPIRATION_NEVER)) {
                            TimeZone tz$iv = TimeZone.getTimeZone(RsaApiKeyMessage.UTC);
                            SimpleDateFormat sdf$iv = new SimpleDateFormat(RsaApiKeyMessage.DATE_FORMAT, Locale.US);
                            sdf$iv.setTimeZone(tz$iv);
                            Date expiration$iv = sdf$iv.parse((String)$this$isExpiredInternal$iv);
                            Date now$iv = Calendar.getInstance(tz$iv).getTime();
                            expiration$iv.before(now$iv);
                        }
                        $this$isExpiredInternal$iv = dateString;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to determine expiration= from " + (String)dateString, e);
                    }
                    object = $this$isExpiredInternal$iv;
                }
            } else {
                throw new IllegalArgumentException("Failed to determine expiration= value");
            }
            Object expiration = object;
            object2 = (String)CollectionsKt.getOrNull((List)lines, (int)4);
            if (object2 != null && (string = StringsKt.substringAfter$default((String)object2, (String)RsaApiKeyMessage.ARG_UUID, null, (int)2, null)) != null) {
                uuidString = string;
                boolean bl = false;
                String exMessage = "Failed to determine uuid= from " + uuidString;
                if (!(uuidString.length() == 29)) {
                    boolean $i$a$-require-RsaApiKeyMessage$Companion$fromString$uuid$1$32 = false;
                    String $i$a$-require-RsaApiKeyMessage$Companion$fromString$uuid$1$32 = exMessage;
                    throw new IllegalArgumentException($i$a$-require-RsaApiKeyMessage$Companion$fromString$uuid$1$32.toString());
                }
                CharSequence charSequence = StringsKt.replace$default((String)uuidString, (String)"-", (String)"", (boolean)false, (int)4, null);
                if (!new Regex("[0123456789ABCDEFGHJKMNPQRSTVWXYZ]{24}").matches(charSequence)) {
                    boolean bl4 = false;
                    String string5 = exMessage;
                    throw new IllegalArgumentException(string5.toString());
                }
            } else {
                throw new IllegalArgumentException("Failed to determine uuid= value");
            }
            String uuid = uuidString;
            return new RsaApiKeyMessage(isDevKey, packageName, type, (String)expiration, uuid, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Validator;", "", "()V", "ALGO_KEYS", "", "ALGO_SIGNATURE", "DELIMITER", "", "validate", "Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage;", "rsaApiKey", "b64ProdRsaPubKey", "b64DevRsaPubKey", "verifySignature", "", "message", "", "b64RsaPubKey", "b64MessageSignature", "rsa-api-key-validator"})
    public static final class Validator {
        @NotNull
        public static final Validator INSTANCE = new Validator();
        @NotNull
        public static final String ALGO_SIGNATURE = "SHA256withRSA";
        @NotNull
        public static final String ALGO_KEYS = "RSA";
        public static final char DELIMITER = ':';

        private Validator() {
        }

        @JvmStatic
        @NotNull
        public static final RsaApiKeyMessage validate(@NotNull String rsaApiKey, @NotNull String b64ProdRsaPubKey, @Nullable String b64DevRsaPubKey) throws IllegalArgumentException {
            String pubKey;
            String string;
            Intrinsics.checkNotNullParameter((Object)rsaApiKey, (String)"rsaApiKey");
            Intrinsics.checkNotNullParameter((Object)b64ProdRsaPubKey, (String)"b64ProdRsaPubKey");
            char[] cArray = new char[1];
            cArray[0] = 58;
            List splits = StringsKt.split$default((CharSequence)rsaApiKey, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splits.size() != 2) {
                throw new IllegalArgumentException("Failed to split provided rsaApiKey into message and signature");
            }
            String $this$decodeBase64ToArray$iv = (String)splits.get(0);
            boolean $i$f$decodeBase64ToArray = false;
            char[] cArray2 = $this$decodeBase64ToArray$iv.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            byte[] byArray = Base64Kt.decodeBase64ToArray((char[])cArray2);
            if (byArray == null) {
                throw new IllegalArgumentException("Failed to base64 decode message");
            }
            byte[] message = byArray;
            RsaApiKeyMessage apiKeyMessage = Companion.fromString(StringsKt.decodeToString((byte[])message));
            if (apiKeyMessage.isDevKey) {
                string = b64DevRsaPubKey;
                if (string == null) {
                    throw new DevKeyException("Development Keys do not work in production. A production key must be used.");
                }
            } else {
                string = b64ProdRsaPubKey;
            }
            if (!INSTANCE.verifySignature(message, pubKey = string, (String)splits.get(1))) {
                throw new IllegalArgumentException("Failed to verify message's signature");
            }
            return apiKeyMessage;
        }

        private final boolean verifySignature(byte[] message, String b64RsaPubKey, String b64MessageSignature) throws IllegalArgumentException {
            boolean bl;
            String $this$decodeBase64ToArray$iv = b64MessageSignature;
            boolean $i$f$decodeBase64ToArray = false;
            char[] cArray = $this$decodeBase64ToArray$iv.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            byte[] byArray = Base64Kt.decodeBase64ToArray((char[])cArray);
            if (byArray == null) {
                throw new IllegalArgumentException("Failed to decode signature");
            }
            byte[] sigBytes = byArray;
            String $this$decodeBase64ToArray$iv2 = b64RsaPubKey;
            boolean $i$f$decodeBase64ToArray2 = false;
            char[] cArray2 = $this$decodeBase64ToArray$iv2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            byte[] byArray2 = Base64Kt.decodeBase64ToArray((char[])cArray2);
            if (byArray2 == null) {
                throw new IllegalArgumentException("Failed to decode rsa public key");
            }
            byte[] pubBytes = byArray2;
            try {
                byte[] $this$verifyRsaSignature$iv = message;
                boolean $i$f$verifyRsaSignature = false;
                PublicKey key$iv = KeyFactory.getInstance(ALGO_KEYS).generatePublic(new X509EncodedKeySpec(pubBytes));
                Signature sig$iv = Signature.getInstance(ALGO_SIGNATURE);
                sig$iv.initVerify(key$iv);
                sig$iv.update($this$verifyRsaSignature$iv);
                bl = sig$iv.verify(sigBytes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to verify message signature", e);
            }
            return bl;
        }
    }
}

