/*
 * Decompiled with CFR 0.152.
 */
package io.toxicity.rsa.api.key.validator;

import io.matthewnelson.component.base64.Base64Kt;
import io.toxicity.rsa.api.key.validator.DevKeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage;", "", "isDevKey", "", "packageName", "", "type", "Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;", "expiration", "uuid", "Ljava/util/UUID;", "(ZLjava/lang/String;Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;Ljava/lang/String;Ljava/util/UUID;)V", "getExpiration", "()Ljava/lang/String;", "()Z", "getPackageName", "getType", "()Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;", "getUuid", "()Ljava/util/UUID;", "equals", "other", "hashCode", "", "isExpired", "toString", "Companion", "Type", "Validator", "rsa-api-key-validator"})
public final class RsaApiKeyMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isDevKey;
    @NotNull
    private final String packageName;
    @NotNull
    private final Type type;
    @NotNull
    private final String expiration;
    @NotNull
    private final UUID uuid;
    @NotNull
    public static final String ARG_IS_DEV_KEY = "isDevKey=";
    @NotNull
    public static final String ARG_PACKAGE_NAME = "packageName=";
    @NotNull
    public static final String ARG_TYPE = "type=";
    @NotNull
    public static final String ARG_EXPIRATION = "expiration=";
    @NotNull
    public static final String ARG_UUID = "uuid=";
    @NotNull
    public static final String EXPIRATION_NEVER = "NEVER";
    @NotNull
    public static final String UTC = "UTC";
    @NotNull
    public static final String DATE_FORMAT = "yyyy-MM-dd' 'HH:mm:ss' UTC'";

    private RsaApiKeyMessage(boolean isDevKey, String packageName, Type type, String expiration, UUID uuid) {
        this.isDevKey = isDevKey;
        this.packageName = packageName;
        this.type = type;
        this.expiration = expiration;
        this.uuid = uuid;
    }

    public final boolean isDevKey() {
        return this.isDevKey;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final String getExpiration() {
        return this.expiration;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final boolean isExpired() {
        TimeZone tz = TimeZone.getTimeZone(UTC);
        Date now = Calendar.getInstance(tz).getTime();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        return Companion.isExpired(this.expiration, now, tz);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RsaApiKeyMessage && ((RsaApiKeyMessage)other).isDevKey == this.isDevKey && Intrinsics.areEqual((Object)((RsaApiKeyMessage)other).packageName, (Object)this.packageName) && ((RsaApiKeyMessage)other).type == this.type && Intrinsics.areEqual((Object)((RsaApiKeyMessage)other).expiration, (Object)this.expiration) && Intrinsics.areEqual((Object)((RsaApiKeyMessage)other).uuid, (Object)this.uuid);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + Boolean.hashCode(this.isDevKey);
        result = result * 31 + this.packageName.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.expiration.hashCode();
        result = result * 31 + this.uuid.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n        RsaApiKeyMessage(\n            isDevKey=" + this.isDevKey + ",\n            packageName=" + this.packageName + ",\n            type=" + this.type + ",\n            expiration=" + this.expiration + ",\n            uuid=" + this.uuid + "\n        )\n    "));
    }

    public /* synthetic */ RsaApiKeyMessage(boolean isDevKey, String packageName, Type type, String expiration, UUID uuid, DefaultConstructorMarker $constructor_marker) {
        this(isDevKey, packageName, type, expiration, uuid);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Type;", "", "(Ljava/lang/String;I)V", "PUSH", "MESSAGE", "rsa-api-key-validator"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PUSH = new Type();
        public static final /* enum */ Type MESSAGE = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.PUSH, Type.MESSAGE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Companion;", "", "()V", "ARG_EXPIRATION", "", "ARG_IS_DEV_KEY", "ARG_PACKAGE_NAME", "ARG_TYPE", "ARG_UUID", "DATE_FORMAT", "EXPIRATION_NEVER", "UTC", "expirationStringToDate", "Ljava/util/Date;", "expiration", "tz", "Ljava/util/TimeZone;", "fromString", "Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage;", "message", "isExpired", "", "now", "rsa-api-key-validator"})
    public static final class Companion {
        private Companion() {
        }

        private final Date expirationStringToDate(String expiration, TimeZone tz) throws ParseException {
            TimeZone timeZone = tz;
            if (timeZone == null) {
                timeZone = TimeZone.getTimeZone(RsaApiKeyMessage.UTC);
            }
            TimeZone tzActual = timeZone;
            SimpleDateFormat sdf = new SimpleDateFormat(RsaApiKeyMessage.DATE_FORMAT, Locale.US);
            sdf.setTimeZone(tzActual);
            Date date = sdf.parse(expiration);
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"sdf.parse(expiration)");
            return date;
        }

        public final boolean isExpired(@NotNull String expiration, @NotNull Date now, @Nullable TimeZone tz) throws ParseException {
            Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
            Intrinsics.checkNotNullParameter((Object)now, (String)"now");
            if (Intrinsics.areEqual((Object)expiration, (Object)RsaApiKeyMessage.EXPIRATION_NEVER)) {
                return false;
            }
            return this.expirationStringToDate(expiration, tz).before(now);
        }

        @NotNull
        public final RsaApiKeyMessage fromString(@NotNull String message) throws IllegalArgumentException {
            UUID uUID;
            Object object;
            Type type;
            String string;
            Object object2;
            String it;
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            List lines = StringsKt.lines((CharSequence)message);
            String string2 = (String)CollectionsKt.getOrNull((List)lines, (int)0);
            if (string2 == null) {
                bl = null;
            } else {
                it = string2;
                boolean bl2 = false;
                object2 = StringsKt.toBooleanStrictOrNull((String)StringsKt.substringAfter$default((String)it, (String)RsaApiKeyMessage.ARG_IS_DEV_KEY, null, (int)2, null));
                if (object2 == null) {
                    throw new IllegalArgumentException("Failed to determine isDevKey= value from " + it);
                }
                bl = (Boolean)object2;
            }
            Boolean bl3 = bl;
            if (bl3 == null) {
                throw new IllegalArgumentException("Failed to determine isDevKey= value");
            }
            boolean isDevKey = bl3;
            String string3 = (String)CollectionsKt.getOrNull((List)lines, (int)1);
            if (string3 == null) {
                string = null;
            } else {
                String it2 = string3;
                boolean bl4 = false;
                String name = StringsKt.substringAfter$default((String)it2, (String)RsaApiKeyMessage.ARG_PACKAGE_NAME, null, (int)2, null);
                if (!(((CharSequence)name).length() > 0)) {
                    boolean $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22 = false;
                    String $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22 = "Package name cannot be empty";
                    throw new IllegalArgumentException($i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22.toString());
                }
                string = name;
            }
            string2 = string;
            if (string2 == null) {
                throw new IllegalArgumentException("Failed to determine packageName= value");
            }
            String packageName = string2;
            it = (String)CollectionsKt.getOrNull((List)lines, (int)2);
            if (it == null) {
                type = null;
            } else {
                String string4 = StringsKt.substringAfter$default((String)it, (String)RsaApiKeyMessage.ARG_TYPE, null, (int)2, null);
                if (string4 == null) {
                    type = null;
                } else {
                    Type $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22;
                    String it3 = string4;
                    boolean bl5 = false;
                    try {
                        $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22 = Type.valueOf(it3);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to determine type= value from " + it3, e);
                    }
                    type = $i$a$-require-RsaApiKeyMessage$Companion$fromString$packageName$1$22;
                }
            }
            string3 = type;
            if (string3 == null) {
                throw new IllegalArgumentException("Failed to determine type= value");
            }
            String type2 = string3;
            String string5 = (String)CollectionsKt.getOrNull((List)lines, (int)3);
            if (string5 == null) {
                object = null;
            } else {
                object2 = StringsKt.substringAfter$default((String)string5, (String)RsaApiKeyMessage.ARG_EXPIRATION, null, (int)2, null);
                if (object2 == null) {
                    object = null;
                } else {
                    Object dateString = object2;
                    boolean bl6 = false;
                    if (Intrinsics.areEqual((Object)dateString, (Object)RsaApiKeyMessage.EXPIRATION_NEVER)) {
                        object = dateString;
                    } else {
                        Object e;
                        try {
                            Companion.expirationStringToDate((String)dateString, null);
                            e = dateString;
                        }
                        catch (ParseException e2) {
                            throw new IllegalArgumentException("Failed to determine expiration= from " + (String)dateString, e2);
                        }
                        object = e;
                    }
                }
            }
            it = object;
            if (it == null) {
                throw new IllegalArgumentException("Failed to determine expiration= value");
            }
            String expiration = it;
            object2 = (String)CollectionsKt.getOrNull((List)lines, (int)4);
            if (object2 == null) {
                uUID = null;
            } else {
                String string6 = StringsKt.substringAfter$default((String)object2, (String)RsaApiKeyMessage.ARG_UUID, null, (int)2, null);
                if (string6 == null) {
                    uUID = null;
                } else {
                    UUID uUID2;
                    String uuidString = string6;
                    boolean bl7 = false;
                    try {
                        uUID2 = UUID.fromString(uuidString);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to determine uuid= from " + uuidString, e);
                    }
                    uUID = uUID2;
                }
            }
            string5 = uUID;
            if (string5 == null) {
                throw new IllegalArgumentException("Failed to determine uuid= value");
            }
            String uuid = string5;
            return new RsaApiKeyMessage(isDevKey, packageName, (Type)((Object)type2), expiration, (UUID)((Object)uuid), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage$Validator;", "", "()V", "ALGO_KEYS", "", "ALGO_SIGNATURE", "DELIMITER", "", "validate", "Lio/toxicity/rsa/api/key/validator/RsaApiKeyMessage;", "rsaApiKey", "b64ProdRsaPubKey", "b64DevRsaPubKey", "verifySignature", "", "message", "", "b64RsaPubKey", "b64MessageSignature", "rsa-api-key-validator"})
    public static final class Validator {
        @NotNull
        public static final Validator INSTANCE = new Validator();
        @NotNull
        public static final String ALGO_SIGNATURE = "SHA256withRSA";
        @NotNull
        public static final String ALGO_KEYS = "RSA";
        public static final char DELIMITER = ':';

        private Validator() {
        }

        @NotNull
        public final RsaApiKeyMessage validate(@NotNull String rsaApiKey, @NotNull String b64ProdRsaPubKey, @Nullable String b64DevRsaPubKey) throws IllegalArgumentException {
            String pubKey;
            String string;
            Intrinsics.checkNotNullParameter((Object)rsaApiKey, (String)"rsaApiKey");
            Intrinsics.checkNotNullParameter((Object)b64ProdRsaPubKey, (String)"b64ProdRsaPubKey");
            char[] cArray = new char[]{':'};
            List splits = StringsKt.split$default((CharSequence)rsaApiKey, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splits.size() != 2) {
                throw new IllegalArgumentException("Failed to split provided rsaApiKey into message and signature");
            }
            String $this$decodeBase64ToArray$iv = (String)splits.get(0);
            boolean $i$f$decodeBase64ToArray = false;
            char[] cArray2 = $this$decodeBase64ToArray$iv.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            byte[] byArray = Base64Kt.decodeBase64ToArray((char[])cArray2);
            if (byArray == null) {
                throw new IllegalArgumentException("Failed to base64 decode message");
            }
            byte[] message = byArray;
            RsaApiKeyMessage apiKeyMessage = Companion.fromString(StringsKt.decodeToString((byte[])message));
            if (apiKeyMessage.isDevKey()) {
                string = b64DevRsaPubKey;
                if (string == null) {
                    throw new DevKeyException("Development Keys do not work in production. A production key must be used.");
                }
            } else {
                string = b64ProdRsaPubKey;
            }
            if (!this.verifySignature(message, pubKey = string, (String)splits.get(1))) {
                throw new IllegalArgumentException("Failed to verify message's signature");
            }
            return apiKeyMessage;
        }

        private final boolean verifySignature(byte[] message, String b64RsaPubKey, String b64MessageSignature) throws IllegalArgumentException {
            boolean bl;
            Object $this$decodeBase64ToArray$iv = b64MessageSignature;
            boolean $i$f$decodeBase64ToArray = false;
            char[] cArray = ((String)$this$decodeBase64ToArray$iv).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            byte[] byArray = Base64Kt.decodeBase64ToArray((char[])cArray);
            if (byArray == null) {
                throw new IllegalArgumentException("Failed to decode signature");
            }
            byte[] sigBytes = byArray;
            String $this$decodeBase64ToArray$iv2 = b64RsaPubKey;
            boolean $i$f$decodeBase64ToArray2 = false;
            char[] cArray2 = $this$decodeBase64ToArray$iv2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            $this$decodeBase64ToArray$iv = Base64Kt.decodeBase64ToArray((char[])cArray2);
            if ($this$decodeBase64ToArray$iv == null) {
                throw new IllegalArgumentException("Failed to decode rsa public key");
            }
            Object pubBytes = $this$decodeBase64ToArray$iv;
            try {
                PublicKey key = KeyFactory.getInstance(ALGO_KEYS).generatePublic(new X509EncodedKeySpec((byte[])pubBytes));
                Signature signature = Signature.getInstance(ALGO_SIGNATURE);
                signature.initVerify(key);
                signature.update(message);
                bl = signature.verify(sigBytes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to verify message signature", e);
            }
            return bl;
        }
    }
}

