/*
 * MIT License
 *
 * Copyright (c) 2022. Toxicity
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 **/
package io.toxicity.rsa.api.key.validator.ext

import io.toxicity.rsa.api.key.validator.RsaApiKeyMessage.Companion.EXPIRATION_NEVER
import kotlinx.datetime.Clock
import kotlinx.datetime.toInstant

@Throws(Exception::class)
@Suppress("nothing_to_inline")
internal actual inline fun String.isExpiredInternal(): Boolean {
    if (this == EXPIRATION_NEVER) {
        return false
    }

    val instant = toIso8601Format().toInstant()
    val now = Clock.System.now()

    return instant.minus(now).isNegative()
}

/*
* Converts time formatted as "yyyy-MM-dd' 'HH:mm:ss' 'UTC"
* to "yyyy-MM-dd'T'HH:mm:ss'Z'"
* */
internal inline fun String.toIso8601Format(): String {
    val splits = split(' ')
    return "${splits[0]}T${splits[1]}Z"
}
