/*
 * Decompiled with CFR 0.152.
 */
package io.tokenchannel;

import com.google.gson.Gson;
import io.tokenchannel.AuthenticateResponse;
import io.tokenchannel.ChallengeOptions;
import io.tokenchannel.ChallengeResponse;
import io.tokenchannel.ChannelType;
import io.tokenchannel.ErrorInfo;
import io.tokenchannel.SMSPriceItem;
import io.tokenchannel.TestResponse;
import io.tokenchannel.TokenChannelProperties;
import io.tokenchannel.VoicePriceItem;
import io.tokenchannel.exceptions.BadRequestException;
import io.tokenchannel.exceptions.ChallengeClosedException;
import io.tokenchannel.exceptions.ChallengeExpiredException;
import io.tokenchannel.exceptions.ChallengeNotFoundException;
import io.tokenchannel.exceptions.ForbiddenException;
import io.tokenchannel.exceptions.InvalidCodeException;
import io.tokenchannel.exceptions.InvalidIdentifierException;
import io.tokenchannel.exceptions.MaxAttemptsExceededException;
import io.tokenchannel.exceptions.OutOfBalanceException;
import io.tokenchannel.exceptions.QuotaExceededException;
import io.tokenchannel.exceptions.TargetOptOutException;
import io.tokenchannel.exceptions.TokenChannelException;
import io.tokenchannel.exceptions.UnauthorizedException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TokenChannel {
    public static final String TOKENCHANNEL_BASE_URI = "https://api.tokenchannel.io";
    private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private final TokenChannelProperties properties;
    private final Gson gson;

    public TokenChannel(TokenChannelProperties properties, Gson gson) {
        this.properties = properties;
        this.gson = gson;
    }

    public CompletableFuture<ChallengeResponse> challenge(ChannelType channel, String identifier, ChallengeOptions options) {
        if (this.properties.getTestMode() != null && this.properties.getTestMode().booleanValue()) {
            options.setTest(true);
        }
        try {
            HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/challenge/%s/%s", TOKENCHANNEL_BASE_URI, channel.toString(), URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString())))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(options != null ? this.gson.toJson((Object)options) : "{}")).build();
            CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
            return response.thenApply(r -> this.processResponse((HttpResponse<String>)r, (Class)ChallengeResponse.class));
        }
        catch (UnsupportedEncodingException ie) {
            throw new TokenChannelException(ie);
        }
    }

    public CompletableFuture<AuthenticateResponse> authenticate(String requestId, String authCode) {
        HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/authenticate/%s/%s", TOKENCHANNEL_BASE_URI, requestId, authCode))).POST(HttpRequest.BodyPublishers.ofString("{}")).build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return response.thenApply(r -> this.processResponse((HttpResponse<String>)r, (Class)AuthenticateResponse.class));
    }

    public CompletableFuture<TestResponse> getValidationCodeByTestChallengeId(String requestId) {
        HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/test/%s", TOKENCHANNEL_BASE_URI, requestId))).GET().build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return response.thenApply(r -> this.processResponse((HttpResponse<String>)r, (Class)TestResponse.class));
    }

    public CompletableFuture<List<String>> getSupportedCountries() {
        HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/countries", TOKENCHANNEL_BASE_URI))).GET().build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return response.thenApply(r -> Arrays.asList(this.processResponse((HttpResponse<String>)r, (Class)String[].class)));
    }

    public CompletableFuture<List<String>> getSupportedLanguages() {
        HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/languages", TOKENCHANNEL_BASE_URI))).GET().build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return response.thenApply(r -> Arrays.asList(this.processResponse((HttpResponse<String>)r, (Class)String[].class)));
    }

    public CompletableFuture<List<SMSPriceItem>> getSMSPrices() {
        HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/pricing/sms", TOKENCHANNEL_BASE_URI))).GET().build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return response.thenApply(r -> Arrays.asList(this.processResponse((HttpResponse<String>)r, (Class)SMSPriceItem[].class)));
    }

    public CompletableFuture<List<VoicePriceItem>> getVoicePrices() {
        HttpRequest httpRequest = this.buildDefaultHttpRequest(URI.create(String.format("%s/pricing/voice", TOKENCHANNEL_BASE_URI))).GET().build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return response.thenApply(r -> Arrays.asList(this.processResponse((HttpResponse<String>)r, (Class)VoicePriceItem[].class)));
    }

    private HttpRequest.Builder buildDefaultHttpRequest(URI uri) {
        return HttpRequest.newBuilder().timeout(Duration.ofSeconds(this.properties.getTimeoutInSeconds())).header("X-Api-Key", this.properties.getApiKey()).header("User-Agent", "TokenChannel/Java11").header("Accept", "application/json; utf-8").uri(uri);
    }

    private <T> T processResponse(HttpResponse<String> response, Class<T> responseType) {
        if (response.statusCode() == 200) {
            return (T)this.gson.fromJson(response.body(), responseType);
        }
        if (response.statusCode() == 400 || response.statusCode() == 404) {
            ErrorInfo errorInfo = (ErrorInfo)this.gson.fromJson(response.body(), ErrorInfo.class);
            if (response.statusCode() == 400) {
                if (errorInfo.getCode().equals("InvalidCode")) {
                    throw new InvalidCodeException();
                }
                if (errorInfo.getCode().equals("InvalidIdentifier")) {
                    throw new InvalidIdentifierException(errorInfo.getMessage());
                }
                if (errorInfo.getCode().equals("OptOut")) {
                    throw new TargetOptOutException();
                }
                throw new BadRequestException(errorInfo);
            }
            if (errorInfo.getCode().equals("ChallengeExpired")) {
                throw new ChallengeExpiredException();
            }
            if (errorInfo.getCode().equals("ChallengeClosed")) {
                throw new ChallengeClosedException();
            }
            if (errorInfo.getCode().equals("MaxAttemptsExceeded")) {
                throw new MaxAttemptsExceededException();
            }
            throw new ChallengeNotFoundException();
        }
        if (response.statusCode() == 401) {
            throw new UnauthorizedException();
        }
        if (response.statusCode() == 402) {
            throw new OutOfBalanceException();
        }
        if (response.statusCode() == 403) {
            throw new ForbiddenException();
        }
        if (response.statusCode() == 429) {
            throw new QuotaExceededException();
        }
        throw new TokenChannelException(String.format("Unexpected error response", new Object[0]));
    }
}

