/*
 * Decompiled with CFR 0.152.
 */
package io.tokenchannel;

import com.google.gson.Gson;
import io.tokenchannel.AuthenticateResponse;
import io.tokenchannel.ChallengeOptions;
import io.tokenchannel.ChallengeResponse;
import io.tokenchannel.ChannelType;
import io.tokenchannel.ErrorInfo;
import io.tokenchannel.SMSPriceItem;
import io.tokenchannel.TestResponse;
import io.tokenchannel.TokenChannelProperties;
import io.tokenchannel.VoicePriceItem;
import io.tokenchannel.exceptions.BadRequestException;
import io.tokenchannel.exceptions.ChallengeClosedException;
import io.tokenchannel.exceptions.ChallengeExpiredException;
import io.tokenchannel.exceptions.ChallengeNotFoundException;
import io.tokenchannel.exceptions.ForbiddenException;
import io.tokenchannel.exceptions.InvalidCodeException;
import io.tokenchannel.exceptions.InvalidIdentifierException;
import io.tokenchannel.exceptions.MaxAttemptsExceededException;
import io.tokenchannel.exceptions.OutOfBalanceException;
import io.tokenchannel.exceptions.QuotaExceededException;
import io.tokenchannel.exceptions.TargetOptOutException;
import io.tokenchannel.exceptions.TokenChannelException;
import io.tokenchannel.exceptions.UnauthorizedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class TokenChannel {
    public static final String TOKENCHANNEL_BASE_URI = "https://api.tokenchannel.io";
    private final TokenChannelProperties properties;
    private final Gson gson;

    public TokenChannel(TokenChannelProperties properties, Gson gson) {
        this.properties = properties;
        this.gson = gson;
    }

    public ChallengeResponse challenge(ChannelType channel, String identifier, ChallengeOptions options) {
        if (this.properties.getTestMode() != null && this.properties.getTestMode().booleanValue()) {
            options.setTest(true);
        }
        try {
            String uri = String.format("%s/challenge/%s/%s", TOKENCHANNEL_BASE_URI, channel.toString(), URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
            HttpURLConnection con = this.buildConnection(uri, "POST");
            try (OutputStream os = con.getOutputStream();){
                byte[] input = this.gson.toJson((Object)options).getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            return this.processResponse(con, ChallengeResponse.class);
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    public AuthenticateResponse authenticate(String requestId, String authCode) {
        String uri = String.format("%s/authenticate/%s/%s", TOKENCHANNEL_BASE_URI, requestId, authCode);
        try {
            HttpURLConnection con = this.buildConnection(uri, "POST");
            return this.processResponse(con, AuthenticateResponse.class);
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    public TestResponse getValidationCodeByTestChallengeId(String requestId) {
        String uri = String.format("%s/test/%s", TOKENCHANNEL_BASE_URI, requestId);
        try {
            HttpURLConnection con = this.buildConnection(uri, "GET");
            return this.processResponse(con, TestResponse.class);
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    public List<String> getSupportedCountries() {
        String uri = String.format("%s/countries", TOKENCHANNEL_BASE_URI);
        try {
            HttpURLConnection con = this.buildConnection(uri, "GET");
            return Arrays.asList(this.processResponse(con, String[].class));
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    public List<String> getSupportedLanguages() {
        String uri = String.format("%s/languages", TOKENCHANNEL_BASE_URI);
        try {
            HttpURLConnection con = this.buildConnection(uri, "GET");
            return Arrays.asList(this.processResponse(con, String[].class));
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    public List<SMSPriceItem> getSMSPrices() {
        String uri = String.format("%s/pricing/sms", TOKENCHANNEL_BASE_URI);
        try {
            HttpURLConnection con = this.buildConnection(uri, "GET");
            return Arrays.asList(this.processResponse(con, SMSPriceItem[].class));
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    public List<VoicePriceItem> getVoicePrices() {
        String uri = String.format("%s/pricing/voice", TOKENCHANNEL_BASE_URI);
        try {
            HttpURLConnection con = this.buildConnection(uri, "GET");
            return Arrays.asList(this.processResponse(con, VoicePriceItem[].class));
        }
        catch (IOException e) {
            throw new TokenChannelException(e);
        }
    }

    private HttpURLConnection buildConnection(String uri, String httpMethod) throws IOException {
        URL url = new URL(uri);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("Content-Type", "application/json; utf-8");
        con.setRequestProperty("Accept", "application/json; utf-8");
        con.setRequestProperty("X-Api-Key", this.properties.getApiKey());
        con.setRequestProperty("User-Agent", "io/tokenchannel/java");
        con.setDoOutput(true);
        int timeout = this.properties.getTimeoutInSeconds() * 1000;
        con.setConnectTimeout(timeout);
        con.setReadTimeout(timeout);
        con.setRequestMethod(httpMethod);
        return con;
    }

    private <T> T processResponse(HttpURLConnection con, Class<T> responseType) throws IOException {
        if (con.getResponseCode() == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));){
                StringBuilder response = new StringBuilder();
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                Object object = this.gson.fromJson(response.toString(), responseType);
                return (T)object;
            }
        }
        if (con.getResponseCode() == 400 || con.getResponseCode() == 404) {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getErrorStream(), "utf-8"));
            try {
                StringBuilder response = new StringBuilder();
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                if (con.getResponseCode() == 400) {
                    ErrorInfo errorInfo = (ErrorInfo)this.gson.fromJson(response.toString(), ErrorInfo.class);
                    if (errorInfo.getCode().equals("InvalidCode")) {
                        throw new InvalidCodeException();
                    }
                    if (errorInfo.getCode().equals("InvalidIdentifier")) {
                        throw new InvalidIdentifierException(errorInfo.getMessage());
                    }
                    if (errorInfo.getCode().equals("OptOut")) {
                        throw new TargetOptOutException();
                    }
                    throw new BadRequestException(errorInfo);
                }
                ErrorInfo errorInfo = (ErrorInfo)this.gson.fromJson(response.toString(), ErrorInfo.class);
                if (errorInfo.getCode().equals("ChallengeExpired")) {
                    throw new ChallengeExpiredException();
                }
                if (errorInfo.getCode().equals("ChallengeClosed")) {
                    throw new ChallengeClosedException();
                }
                if (errorInfo.getCode().equals("MaxAttemptsExceeded")) {
                    throw new MaxAttemptsExceededException();
                }
                throw new ChallengeNotFoundException();
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (con.getResponseCode() == 401) {
            throw new UnauthorizedException();
        }
        if (con.getResponseCode() == 402) {
            throw new OutOfBalanceException();
        }
        if (con.getResponseCode() == 403) {
            throw new ForbiddenException();
        }
        if (con.getResponseCode() == 429) {
            throw new QuotaExceededException();
        }
        throw new TokenChannelException(String.format("Unexpected error response: ", con.getResponseCode()));
    }
}

