/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.postin.doclet.starter;

import io.tiklab.postin.doclet.handler.CustomTagsHandler;
import io.tiklab.postin.doclet.starter.DocletApplication;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class StaterCommon {
    public void staterFunction() throws IOException {
        DocumentationTool documentationTool = ToolProvider.getSystemDocumentationTool();
        if (documentationTool == null) {
            return;
        }
        StandardJavaFileManager fileManager = documentationTool.getStandardFileManager(null, null, Charset.forName("UTF-8"));
        ArrayList compilationUnitsList = new ArrayList();
        ArrayList<File> javaFiles = new ArrayList<File>();
        if (DocletApplication.modulesPathArray != null) {
            for (String path : DocletApplication.modulesPathArray) {
                String dir = (String)path + "/src/main/java";
                System.out.println(dir);
                this.findJavaFiles(new File(dir), javaFiles);
            }
        }
        if (javaFiles.size() > 0) {
            for (File javaFile : javaFiles) {
                Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjects(javaFile);
                compilationUnitsList.addAll((Collection)fileObjects);
            }
        } else {
            System.out.println("javaFile\u4e3a\u7a7a");
            return;
        }
        if (compilationUnitsList.size() == 0) {
            System.out.println("Error --- \u7f16\u8bd1\u7684\u6587\u4ef6\u4e3a\u7a7a");
            return;
        }
        CustomTagsHandler doclet = new CustomTagsHandler();
        StringBuilder classpathBuilder = new StringBuilder();
        this.getClassPath(classpathBuilder);
        if (classpathBuilder.isEmpty()) {
            System.out.println("Error --- \u4f9d\u8d56\u6587\u4ef6\u6784\u9020\u7684classpath\u4e3a\u7a7a");
            return;
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        options.add(classpathBuilder.toString());
        try {
            DocumentationTool.DocumentationTask task = documentationTool.getTask(null, fileManager, null, doclet.getClass(), options, compilationUnitsList);
            Boolean success = task.call();
            if (success.booleanValue()) {
                System.out.println("\u6267\u884c\u6210\u529f");
            } else {
                System.out.println("Error --- \u6267\u884c\u5931\u8d25");
            }
            fileManager.close();
        }
        catch (Exception e) {
            System.out.println("Error --- \u6267\u884c\u9519\u8bef: " + e);
        }
    }

    private void findJavaFiles(File directory, List<File> javaFiles) {
        try {
            boolean isDir = directory.isDirectory();
            if (!isDir) {
                return;
            }
            File[] files = directory.listFiles();
            if (files == null) {
                System.out.println("is not file ");
                return;
            }
            for (File file : files) {
                if (file.isDirectory() && "model".equals(file.getName())) {
                    this.getAllFilesInDirectory(file, javaFiles);
                }
                if (file.getName().endsWith("Controller.java")) {
                    javaFiles.add(file);
                }
                if (!file.isDirectory()) continue;
                this.findJavaFiles(file, javaFiles);
            }
        }
        catch (Exception e) {
            System.out.println("file Error " + e);
        }
    }

    private void getAllFilesInDirectory(File directory, List<File> files) {
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            Collections.addAll(files, fileList);
        }
    }

    private void getClassPath(StringBuilder classpathBuilder) {
        for (String path : DocletApplication.modulesPathArray) {
            File directory = new File(path + "/target/dependency");
            File[] jarFiles = directory.listFiles((dir, name) -> name.endsWith(".jar"));
            if (jarFiles == null) {
                return;
            }
            for (File jarFile : jarFiles) {
                classpathBuilder.append(jarFile.getAbsolutePath()).append(File.pathSeparator);
            }
        }
    }
}

