/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.postin.doclet.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.tiklab.postin.doclet.common.DocletGetModel;
import io.tiklab.postin.doclet.handler.CustomTagsHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ReportData {
    public static JSONObject getHttpApiJson(JSONObject methodJson, Map<String, String> classMap, String categoryId) {
        JSONObject httpApiJson = new JSONObject();
        JSONObject apixJson = new JSONObject();
        JSONObject categoryJson = new JSONObject();
        categoryJson.put("id", (Object)categoryId);
        apixJson.put("category", (Object)categoryJson);
        apixJson.put("name", (Object)methodJson.getString("name"));
        apixJson.put("method", (Object)methodJson.getString("method"));
        apixJson.put("protocol", (Object)classMap.get("protocol"));
        httpApiJson.put("apix", (Object)apixJson);
        httpApiJson.put("path", (Object)methodJson.getString("path"));
        httpApiJson.put("methodType", (Object)methodJson.getString("method"));
        return httpApiJson;
    }

    public static JSONObject getApiRequest(JSONObject methodJson) {
        JSONObject apiRequest = new JSONObject();
        String bodyType = methodJson.getString("request-type");
        if (bodyType.equals("json")) {
            apiRequest.put("bodyType", (Object)"raw");
        } else {
            apiRequest.put("bodyType", (Object)bodyType);
        }
        return apiRequest;
    }

    public static ArrayList<Object> getFormDataJson(JSONObject methodJson, String apiId) {
        JSONArray params = methodJson.getJSONArray("params");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object param : params) {
            JSONObject paramJson = (JSONObject)param;
            JSONObject formParam = new JSONObject();
            JSONObject http = new JSONObject();
            http.put("id", (Object)apiId);
            formParam.put("http", (Object)http);
            formParam.put("paramName", (Object)paramJson.getString("name"));
            formParam.put("dataType", (Object)paramJson.getString("dataType"));
            formParam.put("value", (Object)paramJson.getString("value"));
            formParam.put("desc", (Object)paramJson.getString("desc"));
            arrayList.add(formParam);
        }
        return arrayList;
    }

    public static ArrayList<Object> getFormUrlList(JSONObject methodMap, String apiId) {
        JSONArray params = methodMap.getJSONArray("param");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object param : params) {
            JSONObject paramJson = (JSONObject)param;
            JSONObject formUrlencoded = new JSONObject();
            JSONObject http = new JSONObject();
            http.put("id", (Object)apiId);
            formUrlencoded.put("http", (Object)http);
            formUrlencoded.put("paramName", (Object)paramJson.getString("name"));
            formUrlencoded.put("dataType", (Object)paramJson.getString("dataType"));
            formUrlencoded.put("value", (Object)paramJson.getString("value"));
            arrayList.add(formUrlencoded);
        }
        return arrayList;
    }

    public static JSONObject getRawJson(JSONObject methodJson, String apiId, ExecutableElement method) {
        JSONObject rawJson = new JSONObject();
        rawJson.put("id", (Object)apiId);
        JSONObject http = new JSONObject();
        http.put("id", (Object)apiId);
        rawJson.put("http", (Object)http);
        if ("json".equals(methodJson.getString("request-type"))) {
            List<? extends VariableElement> parameters = method.getParameters();
            String modelFullName = parameters.get(0).asType().toString();
            JSONObject jsonObject = CustomTagsHandler.modelMap.get(modelFullName) != null ? CustomTagsHandler.modelMap.get(modelFullName) : DocletGetModel.loopModel(modelFullName, 0);
            String jsonText = "{}";
            if (jsonObject != null) {
                jsonText = jsonObject.toJSONString();
            }
            rawJson.put("raw", (Object)jsonText);
            rawJson.put("type", (Object)"application/json");
        } else {
            rawJson.put("raw", (Object)methodJson.getString("param"));
            rawJson.put("type", (Object)"text/plain");
        }
        return rawJson;
    }
}

