/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.postin.doclet.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.tiklab.postin.doclet.common.DocletGetModel;
import io.tiklab.postin.doclet.common.DocletUtils;
import io.tiklab.postin.doclet.handler.ReportData;
import io.tiklab.postin.doclet.starter.DocletApplication;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class CustomTagsHandler
implements Doclet {
    public static HashMap<String, JSONObject> modelMap = new HashMap();
    private Reporter reporter;

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return "CustomTagsHandler";
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        Set<? extends Element> elements = environment.getSpecifiedElements();
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            String classComment = environment.getElementUtils().getDocComment(type);
            if (classComment != null && classComment.contains("@pi.model")) {
                this.parseModel(type, classComment, environment);
            }
            if (classComment == null || !classComment.contains("@pi.protocol") || !classComment.contains("@pi.groupName")) continue;
            this.parseController(type, classComment, environment);
        }
        return true;
    }

    private void parseController(TypeElement type, String classComment, DocletEnvironment environment) {
        Map<String, String> classMap = this.parseClassComment(classComment);
        JSONObject moduleJson = new JSONObject();
        String groupName = classMap.get("groupName");
        String categoryId = DocletUtils.getIdByMd5(groupName);
        JSONObject categoryJson = this.getCategoryJson(classMap, categoryId);
        moduleJson.put("category", (Object)categoryJson);
        List<? extends Element> members = type.getEnclosedElements();
        if (members == null || members.size() == 0) {
            return;
        }
        JSONArray moduleMethodList = new JSONArray();
        for (Element element : members) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            String methodComment = environment.getElementUtils().getDocComment(method);
            if (methodComment == null) continue;
            JSONObject apiJson = this.analyticalApi(methodComment, classMap, categoryId, method);
            moduleMethodList.add((Object)apiJson);
        }
        moduleJson.put("moduleMethodList", (Object)moduleMethodList);
        this.httpCommon(groupName, moduleJson.toJSONString());
    }

    private void parseModel(TypeElement type, String classComment, DocletEnvironment environment) {
        List<? extends Element> members = type.getEnclosedElements();
        if (members == null || members.size() == 0) {
            return;
        }
        JSONObject variableJson = new JSONObject();
        for (Element element : members) {
            if (element.getKind() != ElementKind.FIELD) continue;
            VariableElement variable = (VariableElement)element;
            String variableComment = environment.getElementUtils().getDocComment(variable);
            if (variableComment == null) continue;
            this.parseVariableComment(variableComment, variableJson, variable);
        }
        String modelName = this.extractTagValue(classComment, "@pi.model:");
        modelMap.put(modelName, variableJson);
    }

    private JSONObject getCategoryJson(Map<String, String> classMap, String categoryId) {
        JSONObject categoryJson = new JSONObject();
        JSONObject workspaceJson = new JSONObject();
        workspaceJson.put("id", (Object)DocletApplication.workspaceId);
        categoryJson.put("workspace", (Object)workspaceJson);
        categoryJson.put("name", (Object)classMap.get("groupName"));
        categoryJson.put("id", (Object)categoryId);
        return categoryJson;
    }

    private JSONObject analyticalApi(String methodComment, Map<String, String> classMap, String categoryId, ExecutableElement method) {
        JSONObject methodJson = this.parseMethodComment(methodComment);
        JSONObject apiJson = new JSONObject();
        JSONObject httpApiJson = ReportData.getHttpApiJson(methodJson, classMap, categoryId);
        apiJson.put("apiBase", (Object)httpApiJson);
        JSONObject apiRequest = ReportData.getApiRequest(methodJson);
        apiJson.put("request", (Object)apiRequest);
        String path = httpApiJson.getString("path");
        String apiId = DocletUtils.getIdByMd5(path);
        apiJson.put("apiId", (Object)apiId);
        if (apiId == null) {
            return methodJson;
        }
        switch (methodJson.getString("request-type")) {
            case "formdata": {
                ArrayList<Object> formDataJsonList = ReportData.getFormDataJson(methodJson, apiId);
                apiJson.put("formList", formDataJsonList);
                break;
            }
            case "formUrlencoded": {
                ArrayList<Object> formUrlList = ReportData.getFormUrlList(methodJson, apiId);
                apiJson.put("formUrlList", formUrlList);
                break;
            }
            case "json": 
            case "raw": {
                JSONObject rawJson = ReportData.getRawJson(methodJson, apiId, method);
                apiJson.put("raw", (Object)rawJson);
                break;
            }
        }
        JSONObject responseJson = this.getResponseJson(method);
        apiJson.put("response", (Object)responseJson);
        return apiJson;
    }

    private JSONObject getResponseJson(ExecutableElement method) {
        DeclaredType returnType = (DeclaredType)method.getReturnType();
        TypeElement simpleName = (TypeElement)returnType.asElement();
        JSONObject jsonData = DocletGetModel.loopModel(simpleName.toString(), 0);
        JSONObject jsonText = this.jsonToSchema(jsonData);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"\u6210\u529f");
        jsonObject.put("httpCode", (Object)200);
        jsonObject.put("dataType", (Object)"json");
        jsonObject.put("jsonText", (Object)jsonText.toJSONString());
        return jsonObject;
    }

    public JSONObject jsonToSchema(JSONObject json) {
        JSONObject schema = new JSONObject();
        schema.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        schema.put("type", (Object)"object");
        JSONObject properties = new JSONObject();
        for (String key : json.keySet()) {
            Object value = json.get((Object)key);
            JSONObject propSchema = new JSONObject();
            propSchema.put("type", (Object)this.getType(value));
            properties.put(key, (Object)propSchema);
        }
        schema.put("properties", (Object)properties);
        return schema;
    }

    private String getType(Object value) {
        if (value instanceof Integer) {
            return "integer";
        }
        if (value instanceof String) {
            return "string";
        }
        return "object";
    }

    private void httpCommon(String categoryName, String jsonBody) {
        try {
            String serverUrl = DocletApplication.server + "/docletReport/moduleReport";
            URL url = new URL(serverUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                InputStream inputStream = connection.getInputStream();
                StringBuilder response = new StringBuilder();
                Scanner scanner = new Scanner(inputStream);
                while (scanner.hasNextLine()) {
                    response.append(scanner.nextLine());
                }
                JSONObject jsonObject = JSONObject.parseObject((String)response.toString());
                String data = jsonObject.getString("data");
                System.out.println(categoryName + " --- report :" + data);
            } else {
                System.out.println("Error --- http code is not 200 : " + responseCode);
            }
        }
        catch (Exception e) {
            System.out.println("Error --- \u63a5\u53e3\u8c03\u7528\u5931\u8d25 : " + e);
        }
    }

    private Map<String, String> parseClassComment(String classComment) {
        String protocol = this.extractTagValue(classComment, "@pi.protocol:");
        String groupName = this.extractTagValue(classComment, "@pi.groupName:");
        HashMap<String, String> classMap = new HashMap<String, String>();
        classMap.put("protocol", protocol);
        classMap.put("groupName", groupName);
        return classMap;
    }

    private String extractTagValue(String comment, String tagName) {
        int endIndex;
        String tagValue = null;
        int startIndex = comment.indexOf(tagName);
        if (startIndex != -1 && (endIndex = comment.indexOf(10, startIndex)) != -1) {
            tagValue = comment.substring(startIndex + tagName.length(), endIndex).trim();
        }
        return tagValue;
    }

    private JSONObject parseMethodComment(String comment) {
        String[] lines = comment.split("\\R");
        JSONObject methodJson = new JSONObject();
        JSONArray paramList = new JSONArray();
        for (String line : lines) {
            String[] parts;
            if (!line.trim().startsWith("@pi") || (parts = line.split(":", 2)).length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            if ("@pi.name".equals(key)) {
                methodJson.put("name", (Object)value);
                continue;
            }
            if ("@pi.path".equals(key)) {
                methodJson.put("path", (Object)value);
                continue;
            }
            if ("@pi.method".equals(key)) {
                methodJson.put("method", (Object)value);
                continue;
            }
            if ("@pi.request-type".equals(key)) {
                methodJson.put("request-type", (Object)value);
                continue;
            }
            if (!"@pi.param".equals(key)) continue;
            if (value.startsWith("model=")) {
                String model = value.split("=")[1];
                methodJson.put("model", (Object)model);
                continue;
            }
            JSONObject jsonObject = this.parseParam(value);
            paramList.add((Object)jsonObject);
        }
        if (paramList.size() > 0) {
            methodJson.put("params", (Object)paramList);
        }
        return methodJson;
    }

    private JSONObject parseParam(String param) {
        String[] pairs = param.split(";");
        JSONObject jsonObject = new JSONObject();
        for (String pair : pairs) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            jsonObject.put(key, (Object)value);
        }
        return jsonObject;
    }

    private void parseVariableComment(String comment, JSONObject jsonObject, VariableElement variable) {
        String fullModelName = variable.asType().toString();
        String[] lines = comment.split("\\R");
        HashMap<String, String> map = new HashMap<String, String>();
        String egValue = null;
        for (String line : lines) {
            String[] parts;
            if (!line.trim().startsWith("@pi") || (parts = line.split(":", 2)).length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            if (key.equals("@pi.name")) {
                map.put("name", value);
                continue;
            }
            if (key.equals("@pi.value")) {
                egValue = value;
                map.put("value", value);
                continue;
            }
            if (!key.equals("@pi.model")) continue;
            if (modelMap.get(fullModelName) == null) {
                JSONObject jsonObject1 = DocletGetModel.loopModel(fullModelName, 0);
                jsonObject.put(value, (Object)jsonObject1);
                continue;
            }
            jsonObject.put(value, (Object)modelMap.get(fullModelName));
        }
        jsonObject.put((String)map.get("name"), map.get("value"));
    }
}

