/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.postin.doclet.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.tiklab.postin.doclet.starter.DocletApplication;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class DocletGetModel {
    public static JSONObject loopModel(String modelFullName, Integer length) {
        if (length > 3) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            Field[] fields;
            Class<?> paramClass = Class.forName(modelFullName, true, DocletApplication.urlClassLoader);
            for (Field field : fields = paramClass.getDeclaredFields()) {
                if (field.getModifiers() == 26) continue;
                String fieldName = field.getName();
                Class<?> fieldType = field.getType();
                if (fieldType == Integer.TYPE || fieldType.equals(Integer.class)) {
                    jsonObject.put(fieldName, (Object)0);
                    continue;
                }
                if (fieldType == Double.TYPE || fieldType.equals(Double.class)) {
                    jsonObject.put(fieldName, (Object)0.0);
                    continue;
                }
                if (fieldType == Float.TYPE || fieldType.equals(Float.class)) {
                    jsonObject.put(fieldName, (Object)Float.valueOf(0.0f));
                    continue;
                }
                if (fieldType == Long.TYPE || fieldType.equals(Long.class)) {
                    jsonObject.put(fieldName, (Object)0L);
                    continue;
                }
                if (fieldType == Character.TYPE || fieldType.equals(Character.class)) {
                    jsonObject.put(fieldName, (Object)Character.valueOf('\u0000'));
                    continue;
                }
                if (fieldType == Boolean.TYPE || fieldType.equals(Boolean.class)) {
                    jsonObject.put(fieldName, (Object)false);
                    continue;
                }
                if (fieldType == Byte.TYPE) continue;
                if (fieldType == Enum.class || fieldType.isEnum()) {
                    jsonObject.put(fieldName, (Object)fieldName);
                    continue;
                }
                if (fieldType == String.class) {
                    jsonObject.put(fieldName, (Object)fieldName);
                    continue;
                }
                if (fieldType == List.class) {
                    JSONArray jsonArray = new JSONArray();
                    Class<?> listGenericType = DocletGetModel.getListGenericType(field);
                    if (listGenericType != null) {
                        JSONObject elementJson = DocletGetModel.loopModel(listGenericType.getName(), 0);
                        jsonArray.add((Object)elementJson);
                    }
                    jsonObject.put(fieldName, (Object)jsonArray);
                    continue;
                }
                JSONObject modelJson = DocletGetModel.loopModel(fieldType.getName(), 0);
                jsonObject.put(fieldName, (Object)modelJson);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error --- \u83b7\u53d6Class\u5931\u8d25 :" + e);
        }
        return jsonObject;
    }

    private static Class<?> getListGenericType(Field field) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && typeArguments[0] instanceof Class) {
            return (Class)typeArguments[0];
        }
        return null;
    }
}

