/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm.repository;

import io.tiklab.core.exception.SystemException;
import io.tiklab.dal.dsm.repository.model.DsmSchemaHistory;
import io.tiklab.dal.dsm.support.DbConfig;
import io.tiklab.dal.dsm.support.DbConnectionBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsmSchemaHistoryRepository {
    private static Logger logger = LoggerFactory.getLogger(DsmSchemaHistoryRepository.class);
    DbConfig dbConfig;

    public DsmSchemaHistoryRepository(DbConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public void insertSchemaHistory(Connection connection, DsmSchemaHistory schemaHistory) {
        try {
            String sql = "insert into pts_dsm_schema_history(id,app_version,module,module_version,schema_type,status,error_msg,create_time) values(?,?,?,?,?,?,?,?)";
            PreparedStatement ps = connection.prepareStatement(sql);
            ps.setString(1, schemaHistory.getId());
            ps.setString(2, schemaHistory.getAppVersion());
            ps.setString(3, schemaHistory.getModule());
            ps.setString(4, schemaHistory.getModuleVersion());
            ps.setString(5, "");
            ps.setInt(6, schemaHistory.getStatus());
            ps.setString(7, schemaHistory.getErrorMsg());
            ps.setTimestamp(8, schemaHistory.getCreateTime());
            ps.execute();
        }
        catch (SQLException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateSchemaHistory(Connection connection, DsmSchemaHistory schemaHistory) {
        try {
            String sql = "update pts_dsm_schema_history t set t.status=?,t.error_msg=?,t.update_time=? where t.id=?";
            PreparedStatement ps = connection.prepareStatement(sql);
            ps.setInt(1, schemaHistory.getStatus());
            ps.setString(2, schemaHistory.getErrorMsg());
            ps.setTimestamp(3, schemaHistory.getUpdateTime());
            ps.setString(4, schemaHistory.getId());
            ps.execute();
        }
        catch (SQLException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Map<String, DsmSchemaHistory> findSchemaHistoryMap() {
        HashMap<String, DsmSchemaHistory> schemaHistoryMap = new HashMap<String, DsmSchemaHistory>();
        List<DsmSchemaHistory> schemaHistoryList = this.findAllSchemaHistory();
        for (DsmSchemaHistory schemaHistory : schemaHistoryList) {
            String key = schemaHistory.getModule() + "_" + schemaHistory.getModuleVersion();
            schemaHistoryMap.put(key, schemaHistory);
        }
        return schemaHistoryMap;
    }

    public List<DsmSchemaHistory> findAllSchemaHistory() {
        ArrayList<DsmSchemaHistory> schemaHistories = new ArrayList<DsmSchemaHistory>();
        Connection connection = null;
        try {
            connection = DbConnectionBuilder.buildConnection(this.dbConfig);
            connection.setAutoCommit(true);
            String sql = "select t.* from pts_dsm_schema_history t";
            PreparedStatement ps = connection.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DsmSchemaHistory schemaHistory = new DsmSchemaHistory();
                String id = rs.getString("id");
                String appVersion = rs.getString("app_version");
                String module = rs.getString("module");
                String moduleVersion = rs.getString("module_version");
                int status = rs.getInt("status");
                schemaHistory.setId(id);
                schemaHistory.setAppVersion(appVersion);
                schemaHistory.setModule(module);
                schemaHistory.setModuleVersion(moduleVersion);
                schemaHistory.setStatus(status);
                schemaHistories.add(schemaHistory);
            }
            return schemaHistories;
        }
        catch (SQLException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public DsmSchemaHistory findSchemaHistory(String module, String moduleVersion) {
        Connection connection = null;
        try {
            DbConnectionBuilder.buildConnection(this.dbConfig);
            String sql = "select t.* from pts_dsm_schema_history t where t.module=? and t.module_version=?";
            PreparedStatement ps = connection.prepareStatement(sql);
            ps.setString(1, module);
            ps.setString(2, moduleVersion);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                DsmSchemaHistory tableMeta = new DsmSchemaHistory();
                String id = rs.getString("id");
                String appVersion = rs.getString("app_version");
                tableMeta.setId(id);
                tableMeta.setAppVersion(appVersion);
                tableMeta.setModule(module);
                tableMeta.setModuleVersion(moduleVersion);
                return tableMeta;
            }
        }
        catch (SQLException e) {
            throw new SystemException((Throwable)e);
        }
        return null;
    }
}

