/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm;

import io.tiklab.dal.dsm.config.DsmConfigParser;
import io.tiklab.dal.dsm.config.model.DsmConfig;
import io.tiklab.dal.dsm.config.model.DsmModule;
import io.tiklab.dal.dsm.config.model.DsmVersion;
import io.tiklab.dal.dsm.executer.SQLFileExecuter;
import io.tiklab.dal.dsm.repository.DsmSchemaHistoryRepository;
import io.tiklab.dal.dsm.repository.DsmSchemaMetadataRepository;
import io.tiklab.dal.dsm.repository.model.DsmSchemaHistory;
import io.tiklab.dal.dsm.support.DbConfig;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsmProcessor {
    private static Logger logger = LoggerFactory.getLogger(DsmProcessor.class);
    private DbConfig dbConfig;
    private DsmConfig dsmConfig;
    private DsmSchemaMetadataRepository schemaRepository;
    private DsmSchemaHistoryRepository schemaHistoryRepository;
    private Map<String, String> loadedSQLFileMap = new HashMap<String, String>();

    public DsmProcessor() {
    }

    public DsmProcessor(DbConfig dbConfig, DsmConfig dsmConfig) {
        this.dbConfig = dbConfig;
        this.dsmConfig = dsmConfig;
        this.schemaRepository = new DsmSchemaMetadataRepository(dbConfig);
        this.schemaHistoryRepository = new DsmSchemaHistoryRepository(dbConfig);
        this.initSchemaTableIfNotExist();
    }

    void initSchemaTableIfNotExist() {
        this.schemaRepository.createSchemaTablesIfNotExist();
    }

    public void process() {
        if (this.dsmConfig == null || this.dsmConfig.getVersionList() == null || this.dsmConfig.getVersionList().size() == 0) {
            return;
        }
        this.dsmConfig = new DsmConfigParser().parse(this.dsmConfig);
        Map<String, DsmSchemaHistory> schemaHistoryMap = this.schemaHistoryRepository.findSchemaHistoryMap();
        for (DsmVersion dsmVersion : this.dsmConfig.getVersionList()) {
            for (DsmModule dsmFile : dsmVersion.getModules()) {
                String moduleVersion;
                String module = dsmFile.getModule();
                String key = module + "_" + (moduleVersion = dsmFile.getModuleVersion());
                DsmSchemaHistory schemaHistory = schemaHistoryMap.get(key);
                if (schemaHistory != null) continue;
                this.executeSQLFile(dsmFile);
            }
        }
    }

    void executeSQLFile(DsmModule dsmModule) {
        String fileName = dsmModule.getFileName();
        if (this.loadedSQLFileMap.containsKey(fileName)) {
            return;
        }
        new SQLFileExecuter(this.dbConfig, dsmModule).executeFile();
        this.loadedSQLFileMap.put(fileName, fileName);
    }
}

