/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm.repository;

import io.tiklab.core.exception.SystemException;
import io.tiklab.dal.dsm.support.DbConfig;
import io.tiklab.dal.dsm.support.DbConnectionBuilder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsmSchemaMetadataRepository {
    private static Logger logger = LoggerFactory.getLogger(DsmSchemaMetadataRepository.class);
    DbConfig dbConfig;

    public DsmSchemaMetadataRepository(DbConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public void createSchemaTablesIfNotExist() {
        boolean isExist = this.isExistSchemaTable();
        if (!isExist) {
            this.createSchemaTables();
        }
    }

    boolean isExistSchemaTable() {
        Connection connection = null;
        try {
            connection = DbConnectionBuilder.buildConnection(this.dbConfig);
            DatabaseMetaData metaData = connection.getMetaData();
            String catalog = connection.getCatalog();
            String schema = connection.getSchema();
            ResultSet tables = metaData.getTables(catalog, schema, null, new String[]{"TABLE"});
            String tableName = "pts_dsm_schema_history";
            while (tables.next()) {
                String tblName = tables.getString("TABLE_NAME");
                if (!tblName.toLowerCase().equals(tableName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    void createSchemaTables() {
        Connection connection = null;
        try {
            connection = DbConnectionBuilder.buildConnection(this.dbConfig);
            Statement stmt = connection.createStatement();
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE pts_dsm_schema_history(");
            builder.append("    id VARCHAR(32) PRIMARY KEY,");
            builder.append("    app_version VARCHAR(32) NOT NULL,");
            builder.append("    module VARCHAR(32) NOT NULL,");
            builder.append("    module_version VARCHAR(32) NOT NULL,");
            builder.append("    schema_type VARCHAR(32) NOT NULL,");
            builder.append("    status int,");
            builder.append("    error_msg VARCHAR(512),");
            builder.append("    create_time timestamp,");
            builder.append("    update_time timestamp");
            builder.append(");");
            String sql = builder.toString();
            stmt.executeUpdate(sql);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new SystemException((Throwable)e);
            }
        }
    }
}

