/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm.executer;

import io.tiklab.core.exception.SystemException;
import io.tiklab.dal.dsm.config.model.DsmCommand;
import io.tiklab.dal.dsm.config.model.DsmModule;
import io.tiklab.dal.dsm.repository.DsmSchemaHistoryRepository;
import io.tiklab.dal.dsm.repository.model.DsmSchemaHistory;
import io.tiklab.dal.dsm.support.DbConfig;
import io.tiklab.dal.dsm.support.DbConnectionBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLFileExecuter {
    private static Logger logger = LoggerFactory.getLogger(SQLFileExecuter.class);
    private DbConfig dbConfig;
    private DsmModule dsmModule;
    private DsmSchemaHistoryRepository schemaHistoryRepository;

    private SQLFileExecuter() {
    }

    public SQLFileExecuter(DbConfig dbConfig, DsmModule dsmModule) {
        this.dbConfig = dbConfig;
        this.dsmModule = dsmModule;
        this.schemaHistoryRepository = new DsmSchemaHistoryRepository(dbConfig);
    }

    public void executeFile() {
        Connection connection = null;
        try {
            connection = DbConnectionBuilder.buildConnection(this.dbConfig);
            connection.setAutoCommit(false);
            for (DsmCommand command : this.dsmModule.getCommandList()) {
                this.executeCommand(connection, command);
            }
            DsmSchemaHistory schemaHistory = new DsmSchemaHistory(this.dsmModule.getModule(), this.dsmModule.getModuleVersion());
            String uuid = UUID.randomUUID().toString();
            uuid = uuid.substring(0, 16);
            schemaHistory.setId(uuid);
            schemaHistory.setAppVersion(this.dsmModule.getVersion());
            schemaHistory.setStatus(1);
            schemaHistory.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.schemaHistoryRepository.insertSchemaHistory(connection, schemaHistory);
            connection.commit();
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                throw new SystemException((Throwable)ex);
            }
            throw new SystemException("execute sql file failed,file:" + this.dsmModule.getResource().getFilename(), (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    void executeCommand(Connection connection, DsmCommand cmd) {
        Statement statement = null;
        String command = null;
        try {
            statement = connection.createStatement();
            command = cmd.getCmd();
            logger.info("execute sql command:{}", (Object)command);
            statement.executeUpdate(command);
        }
        catch (SQLException e) {
            logger.info("execute sql command failed,command:{}", (Object)command, (Object)e);
            throw new SystemException((Throwable)e);
        }
    }
}

