/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm.config.model;

import io.tiklab.core.exception.ApplicationException;
import io.tiklab.dal.dsm.config.model.DsmModule;
import io.tiklab.dal.dsm.config.model.DsmVersion;
import java.util.ArrayList;
import java.util.List;

public class DsmConfig {
    private List<DsmVersion> versionList = new ArrayList<DsmVersion>();

    public DsmConfig newVersion(String version, DsmModule[] modules) {
        this.addVersion(new DsmVersion(version, modules));
        return this;
    }

    public DsmConfig newVersion(String version, String[] modules) {
        DsmModule[] dsmModules = new DsmModule[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            String fileName = modules[i];
            String[] arr = fileName.split("_");
            if (arr == null || arr.length != 2) {
                throw new ApplicationException("script file name invalid:" + fileName);
            }
            DsmModule module = new DsmModule();
            module.setVersion(version);
            module.setFileName(fileName);
            module.setModule(arr[0]);
            module.setModuleVersion(arr[1]);
            dsmModules[i] = module;
        }
        return this.newVersion(version, dsmModules);
    }

    public List<DsmVersion> getVersionList() {
        return this.versionList;
    }

    public void setVersionList(List<DsmVersion> versionList) {
        this.versionList = versionList;
    }

    public void addVersion(DsmVersion dsmVersion) {
        this.getVersionList().add(dsmVersion);
    }
}

