/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm.config;

import io.tiklab.dal.dsm.config.model.SQLFile;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SQLFileParser {
    private static Logger logger = LoggerFactory.getLogger(SQLFileParser.class);
    private static final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public static Set<SQLFile> loadAllSQLFiles() {
        try {
            HashSet<SQLFile> sqlFiles = new HashSet<SQLFile>();
            String resourcePath = "classpath*:/**/scripts/*.sql";
            Resource[] resources = resolver.getResources(resourcePath);
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                SQLFile sqlFile = SQLFileParser.parseSQLFile(resource);
                if (sqlFile == null) continue;
                sqlFiles.add(sqlFile);
            }
            return sqlFiles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static SQLFile parseSQLFile(Resource resource) {
        SQLFile sqlFile = new SQLFile();
        sqlFile.setFileName(resource.getFilename());
        sqlFile.setResource(resource);
        String fileName = sqlFile.getFileName();
        int lastIndexOf = fileName.lastIndexOf(".");
        fileName = fileName.substring(0, lastIndexOf);
        String[] arr = fileName.split("\\_");
        if (arr.length != 2) {
            logger.warn("sql script file name invalid,file name:{}", (Object)resource.getFilename());
            return null;
        }
        String moudle = arr[0];
        String version = arr[1];
        sqlFile.setModule(moudle);
        sqlFile.setModuleVersion(version);
        return sqlFile;
    }
}

