/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.dal.dsm.config;

import io.tiklab.core.exception.ApplicationException;
import io.tiklab.core.exception.SystemException;
import io.tiklab.dal.dsm.config.SQLFileParser;
import io.tiklab.dal.dsm.config.model.DsmCommand;
import io.tiklab.dal.dsm.config.model.DsmConfig;
import io.tiklab.dal.dsm.config.model.DsmModule;
import io.tiklab.dal.dsm.config.model.DsmVersion;
import io.tiklab.dal.dsm.config.model.SQLFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.Resource;

public class DsmConfigParser {
    private static Set<SQLFile> sqlFiles = null;
    private static String SQL_DELIMITER = ";";

    public DsmConfigParser() {
        if (sqlFiles == null || sqlFiles.size() == 0) {
            sqlFiles = SQLFileParser.loadAllSQLFiles();
        }
    }

    public DsmConfig parse(DsmConfig dsmConfig) {
        for (DsmVersion dsmVersion : dsmConfig.getVersionList()) {
            for (DsmModule dsmFile : dsmVersion.getModules()) {
                String moduleVersion;
                String moduleName = dsmFile.getModule();
                SQLFile sqlFile = this.findSQLFile(moduleName, moduleVersion = dsmFile.getModuleVersion());
                if (sqlFile == null) {
                    String errorMsg = String.format("script file not found,module:%s,version:%s", moduleName, moduleVersion);
                    throw new ApplicationException(errorMsg);
                }
                dsmFile.setFilePath(sqlFile.getFilePath());
                dsmFile.setResource(sqlFile.getResource());
                List<DsmCommand> commandList = this.parseCommands(sqlFile.getResource());
                dsmFile.setCommandList(commandList);
            }
        }
        return dsmConfig;
    }

    SQLFile findSQLFile(String moduleName, String moduleVersion) {
        for (SQLFile sqlFile : sqlFiles) {
            if (!moduleName.equals(sqlFile.getModule()) || !moduleVersion.equals(sqlFile.getModuleVersion())) continue;
            return sqlFile;
        }
        return null;
    }

    List<DsmCommand> parseCommands(Resource resource) {
        ArrayList<DsmCommand> commandList = new ArrayList<DsmCommand>();
        try {
            InputStream stream = resource.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
            LineNumberReader lineReader = new LineNumberReader(bufferedReader);
            String line = null;
            StringBuffer commandBuf = null;
            Object commandId = null;
            while ((line = lineReader.readLine()) != null) {
                if (commandBuf == null) {
                    commandBuf = new StringBuffer();
                }
                if ((line = line.trim()).length() < 1 || this.isCommentLine(line)) continue;
                if (this.isScriptEndLine(line)) {
                    commandBuf.append(line.substring(0, line.lastIndexOf(SQL_DELIMITER)));
                    commandBuf.append(" ");
                    DsmCommand dc = new DsmCommand();
                    dc.setCmd(commandBuf.toString());
                    commandList.add(dc);
                    commandBuf = null;
                    continue;
                }
                commandBuf.append(line);
                commandBuf.append(" ");
            }
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
        return commandList;
    }

    boolean isCommentLine(String line) {
        if (line.startsWith("//")) {
            return true;
        }
        return line.startsWith("--");
    }

    boolean isScriptEndLine(String line) {
        return line.endsWith(SQL_DELIMITER) || line.equals(SQL_DELIMITER);
    }
}

