/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.jexter.core.utils;

import java.lang.reflect.Field;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getObjectField(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field == null) continue;
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    public static <T> T getClassField(Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        while (clazz != Object.class) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field != null) {
                field.setAccessible(true);
                return (T)field.get(null);
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setObjectField(Object obj, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field == null) continue;
            int modifiers = field.getModifiers();
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
            try {
                field.setAccessible(true);
                field.set(obj, value);
                break;
            }
            finally {
                modifiersField.setInt(field, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassField(Class clazz, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        while (clazz != Object.class) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field != null) {
                int modifiers = field.getModifiers();
                modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
                try {
                    field.setAccessible(true);
                    field.set(null, value);
                    break;
                }
                finally {
                    modifiersField.setInt(field, modifiers);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }
}

