/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.jexter.core.envvar;

import io.thundra.jexter.core.utils.ReflectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class EnvironmentVariableHelper {
    private EnvironmentVariableHelper() {
    }

    public static String get(String name) {
        return System.getenv(name);
    }

    public static Map<String, String> getAll() {
        return System.getenv();
    }

    public static Map<String, String> getAllCopy() {
        return Collections.unmodifiableMap(new HashMap<String, String>(System.getenv()));
    }

    public static String set(String name, String value) {
        return EnvironmentVariableHelper.modifyEnvironmentVariables(map -> map.put(name, value));
    }

    public static void setAll(Map<String, String> envVars) {
        EnvironmentVariableHelper.modifyEnvironmentVariables(map -> {
            map.clear();
            map.putAll(envVars);
            return null;
        });
    }

    public static String remove(String name) {
        return EnvironmentVariableHelper.modifyEnvironmentVariables(map -> (String)map.remove(name));
    }

    private static String modifyEnvironmentVariables(Function<Map<String, String>, String> function) {
        try {
            return EnvironmentVariableHelper.setInProcessEnvironmentClass(function);
        }
        catch (ReflectiveOperationException ex) {
            try {
                return EnvironmentVariableHelper.setInSystemEnvClass(function);
            }
            catch (ReflectiveOperationException ex2) {
                ex.addSuppressed(ex2);
                throw new UnsupportedOperationException("Could not modify environment variables", ex);
            }
        }
    }

    private static String setInProcessEnvironmentClass(Function<Map<String, String>, String> function) throws ReflectiveOperationException {
        Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
        Map theEnvironment = (Map)ReflectionUtils.getClassField(processEnvironmentClass, "theEnvironment");
        Map theCaseInsensitiveEnvironment = (Map)ReflectionUtils.getClassField(processEnvironmentClass, "theCaseInsensitiveEnvironment");
        String value = function.apply(theEnvironment);
        function.apply(theCaseInsensitiveEnvironment);
        return value;
    }

    private static String setInSystemEnvClass(Function<Map<String, String>, String> function) throws ReflectiveOperationException {
        Map<String, String> env = System.getenv();
        return function.apply((Map<String, String>)ReflectionUtils.getObjectField(env, "m"));
    }
}

