/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.wildfly.swarm.config.runtime.invocation.EntityAdapter;
import org.wildfly.swarm.config.runtime.invocation.IndexFactory;
import org.wildfly.swarm.config.runtime.invocation.SubresourceFilter;

public class Marshaller {
    private static HashMap<Class<?>, EntityAdapter<?>> adapters = new HashMap();
    private static HashMap<Class<?>, Optional<Subresource>> subresources = new HashMap();

    public static LinkedList<ModelNode> marshal(Object root) throws Exception {
        return Marshaller.appendNode(root, PathAddress.EMPTY_ADDRESS, new LinkedList<ModelNode>());
    }

    private static LinkedList<ModelNode> appendNode(Object entity, PathAddress address, LinkedList<ModelNode> list) throws Exception {
        PathAddress resourceAddress = Marshaller.resourceAddress(entity, address);
        ModelNode modelNode = Marshaller.addressNodeFor(resourceAddress);
        EntityAdapter adapter = Marshaller.adapterFor(entity.getClass());
        ModelNode result = adapter.fromEntity(entity, modelNode);
        if (result != null) {
            list.add(result);
        }
        return Marshaller.marshalSubresources(entity, resourceAddress, list);
    }

    private static PathAddress resourceAddress(Object resource, PathAddress pathAddress) {
        Index index;
        ClassInfo clazz;
        Class<?> entityClass = resource.getClass();
        PathAddress address = Marshaller.getPathElements(resource, pathAddress, entityClass, clazz = (index = IndexFactory.createIndex(entityClass)).getClassByName(DotName.createSimple((String)entityClass.getName())));
        if (address != null) {
            return address;
        }
        throw new RuntimeException("Cannot determine resource address for " + resource);
    }

    private static PathAddress getPathElements(Object resource, PathAddress pathAddress, Class<?> entityClass, ClassInfo clazz) {
        for (AnnotationInstance annotation : clazz.classAnnotations()) {
            if (!annotation.name().equals((Object)IndexFactory.RESOURCE_TYPE)) continue;
            String resourceType = annotation.value().asString();
            String name = null;
            try {
                Method keyMethod = entityClass.getMethod("getKey", new Class[0]);
                name = (String)keyMethod.invoke(resource, new Object[0]);
            }
            catch (NoSuchMethodException keyMethod) {
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            pathAddress = pathAddress.append(resourceType, name);
            return pathAddress;
        }
        if (clazz.superName() != null) {
            Index index = IndexFactory.createIndex(resource.getClass().getSuperclass());
            ClassInfo superClazz = index.getClassByName(clazz.superName());
            return Marshaller.getPathElements(resource, pathAddress, entityClass, superClazz);
        }
        return null;
    }

    private static ModelNode addressNodeFor(PathAddress address) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.toModelNode());
        node.get("operation").set("add");
        return node;
    }

    private static synchronized EntityAdapter adapterFor(Class<?> type) {
        if (!adapters.containsKey(type)) {
            adapters.put(type, new EntityAdapter(type));
        }
        return adapters.get(type);
    }

    public static synchronized Optional<Subresource> subresourcesFor(Object entity) {
        Class<?> type = entity.getClass();
        if (!subresources.containsKey(type)) {
            try {
                Method target = type.getMethod("subresources", new Class[0]);
                subresources.put(type, Optional.of(new Subresource(target.getReturnType(), target)));
            }
            catch (Exception e) {
                subresources.put(type, Optional.empty());
            }
        }
        return subresources.get(type);
    }

    private static List<Method> orderedSubresources(Object parent) throws NoSuchMethodException {
        Class<?> parentClass = parent.getClass();
        return new SubresourceFilter(parentClass).invoke();
    }

    private static LinkedList<ModelNode> marshalSubresources(Object parent, PathAddress address, LinkedList<ModelNode> list) {
        try {
            Optional<Subresource> optional = Marshaller.subresourcesFor(parent);
            if (optional.isPresent()) {
                Object subresources = optional.get().invoke(parent);
                for (Method target : Marshaller.orderedSubresources(subresources)) {
                    if (target.getReturnType() != List.class) continue;
                    List resourceList = (List)target.invoke(subresources, new Object[0]);
                    for (Object o : resourceList) {
                        Marshaller.appendNode(o, address, list);
                    }
                }
                for (Method target : Marshaller.orderedSubresources(subresources)) {
                    Object resource;
                    if (target.getReturnType() == List.class || (resource = target.invoke(subresources, new Object[0])) == null) continue;
                    Marshaller.appendNode(resource, address, list);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error getting subresources for " + parent.getClass().getSimpleName());
            e.printStackTrace();
        }
        return list;
    }

    private static class Subresource {
        public final Class<?> type;
        public final Method method;

        public Subresource(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
        }

        public Object invoke(Object parent) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(parent, new Object[0]);
        }
    }
}

