/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.swarm.config.runtime.invocation.MapTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.SimpleTypeAdapter;
import org.wildfly.swarm.config.runtime.invocation.Types;

public class ListTypeAdapter {
    public void toDmr(ModelNode target, List list) {
        if (list.isEmpty()) {
            target.setEmptyList();
        } else {
            for (Object value : list) {
                ModelNode node = target.add();
                if (value instanceof List) {
                    new ListTypeAdapter().toDmr(node, (List)value);
                    continue;
                }
                if (value instanceof Map) {
                    new MapTypeAdapter().toDmr(node, (Map)value);
                    continue;
                }
                ModelType type = Types.resolveModelType(value.getClass());
                new SimpleTypeAdapter().toDmr(node, type, value);
            }
        }
    }

    public void fromDmr(Object entity, String javaName, ModelType dmrType, Class<?> propertyType, ModelNode dmrPayload) throws Exception {
        List items;
        Method target = entity.getClass().getMethod(javaName, propertyType);
        List list = items = dmrPayload.isDefined() ? dmrPayload.asList() : Collections.EMPTY_LIST;
        if (items.isEmpty()) {
            target.invoke(entity, Collections.EMPTY_LIST);
        } else {
            ArrayList list2 = new ArrayList(items.size());
            ModelType listValueType = ((ModelNode)items.get(0)).getType();
            for (ModelNode item : items) {
                this.addJavaValueTo(list2, listValueType, item);
            }
            target.invoke(entity, list2);
        }
    }

    private void addJavaValueTo(List target, ModelType type, ModelNode propValue) {
        if (type.equals((Object)ModelType.STRING)) {
            target.add(propValue.asString());
        } else if (type.equals((Object)ModelType.INT)) {
            target.add(propValue.asInt());
        } else if (type.equals((Object)ModelType.DOUBLE)) {
            target.add(propValue.asDouble());
        } else if (type.equals((Object)ModelType.LONG)) {
            target.add(propValue.asLong());
        } else if (type.equals((Object)ModelType.BOOLEAN)) {
            target.add(propValue.asBoolean());
        } else {
            throw new RuntimeException("Unsupported DMR type: " + type);
        }
    }
}

