/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.dmr.Property;
import org.wildfly.swarm.config.generator.generator.ClassIndex;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.EnumPlan;
import org.wildfly.swarm.config.generator.generator.EnumRequirement;
import org.wildfly.swarm.config.generator.generator.ResourceMetaData;
import org.wildfly.swarm.config.generator.model.ResourceDescription;
import org.wildfly.swarm.config.runtime.model.AddressTemplate;

public class SubsystemPlan
implements ClassIndex {
    private final ResourceMetaData meta;
    private final List<ClassPlan> classPlans = new ArrayList<ClassPlan>();
    private final List<EnumPlan> enumPlans = new ArrayList<EnumPlan>();
    private Map<AddressTemplate, ClassPlan> index = new HashMap<AddressTemplate, ClassPlan>();

    SubsystemPlan(ResourceMetaData meta) {
        this.meta = meta;
        this.plan();
    }

    @Override
    public ClassPlan lookup(AddressTemplate address) {
        return this.index.get(address);
    }

    @Override
    public EnumPlan lookup(ClassPlan requester, Property attr) {
        return this.enumPlans.stream().filter(e -> e.matches(requester, attr)).findFirst().orElse(null);
    }

    List<ClassPlan> getClassPlans() {
        return this.classPlans;
    }

    List<EnumPlan> getEnumPlans() {
        return this.enumPlans;
    }

    /*
     * WARNING - void declaration
     */
    void plan() {
        ClassPlan subsystemClass = new ClassPlan(this.meta);
        this.classPlans.add(subsystemClass);
        ArrayList<ResourceMetaData> list = new ArrayList<ResourceMetaData>();
        SubsystemPlan.collect(this.meta, list);
        Map<AddressTemplate, List<ResourceMetaData>> grouped = list.stream().collect(Collectors.groupingBy(e -> {
            AddressTemplate address = e.getAddress();
            return address.lastSubTemplate();
        }));
        for (AddressTemplate key : grouped.keySet()) {
            List<ResourceMetaData> members = grouped.get(key);
            if (members.size() > 1) {
                List<List<ResourceMetaData>> list2 = SubsystemPlan.partition(members);
                for (List<ResourceMetaData> list3 : list2) {
                    this.classPlans.add(new ClassPlan(list3));
                }
                continue;
            }
            this.classPlans.add(new ClassPlan(members));
        }
        Collections.sort(this.classPlans);
        ClassPlan cur = null;
        HashSet<ClassPlan> dupes = new HashSet<ClassPlan>();
        for (ClassPlan classPlan : this.classPlans) {
            if (cur != null) {
                if (cur.getFullyQualifiedClassName().equals(classPlan.getFullyQualifiedClassName())) {
                    dupes.add(cur);
                    dupes.add(classPlan);
                } else if (!dupes.isEmpty()) {
                    SubsystemPlan.deduplicate(dupes);
                    dupes.clear();
                }
            }
            cur = classPlan;
        }
        if (!dupes.isEmpty()) {
            SubsystemPlan.deduplicate(dupes);
            dupes.clear();
        }
        for (ClassPlan classPlan : this.classPlans) {
            for (AddressTemplate addressTemplate : classPlan.getAddresses()) {
                this.index.put(addressTemplate, classPlan);
            }
        }
        ArrayList<EnumRequirement> enumRequirements = new ArrayList<EnumRequirement>();
        for (ClassPlan classPlan : this.classPlans) {
            enumRequirements.addAll(classPlan.getEnumRequirements());
        }
        List<List<EnumRequirement>> list4 = SubsystemPlan.partitionEnumRequirements(enumRequirements);
        for (List<EnumRequirement> list5 : list4) {
            if (list5.size() == 1) {
                EnumRequirement requirement = list5.get(0);
                requirement.getOriginatingClassPlan().addEnumPlan(new EnumPlan(null, list5));
                continue;
            }
            this.enumPlans.add(new EnumPlan(SubsystemPlan.subsystemPackage(subsystemClass), list5));
        }
        Collections.sort(this.enumPlans);
        Object var8_20 = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (EnumPlan each : this.enumPlans) {
            void var8_21;
            if (var8_21 != null) {
                if (var8_21.getFullyQualifiedClassName().equals(each.getFullyQualifiedClassName())) {
                    hashSet.add(var8_21);
                    hashSet.add(each);
                } else if (!hashSet.isEmpty()) {
                    System.err.println("A ****** NEED TO DEDUPE ENUM: " + hashSet);
                    for (EnumPlan eachPlan : hashSet) {
                        System.err.println(" - " + eachPlan.getOriginatingClassPlans());
                    }
                    hashSet.clear();
                }
            }
            EnumPlan enumPlan = each;
        }
        if (!hashSet.isEmpty()) {
            System.err.println("B ****** NEED TO DEDUPE ENUM: " + hashSet);
            for (EnumPlan each : hashSet) {
                System.err.println(" - " + each.getOriginatingClassPlans());
            }
            hashSet.clear();
        }
    }

    static String subsystemPackage(ClassPlan subsystemClass) {
        return subsystemClass.getPackageName() + "." + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, subsystemClass.getOriginalClassName()).replace('-', '.');
    }

    static boolean deduplicate(Set<ClassPlan> dupes) {
        block2: {
            int i = 1;
            do {
                for (ClassPlan dupe : dupes) {
                    dupe.deduplicate(i);
                }
                if (!SubsystemPlan.stillContainsDuplicates(dupes)) break block2;
            } while (++i <= 10);
            return false;
        }
        return true;
    }

    static boolean stillContainsDuplicates(Set<ClassPlan> dupes) {
        HashSet<String> seen = new HashSet<String>();
        for (ClassPlan dupe : dupes) {
            if (seen.contains(dupe.getFullyQualifiedClassName())) {
                return true;
            }
            seen.add(dupe.getFullyQualifiedClassName());
        }
        return false;
    }

    static List<List<ResourceMetaData>> partition(List<ResourceMetaData> list) {
        ArrayList<List<ResourceMetaData>> partitions = new ArrayList<List<ResourceMetaData>>();
        for (ResourceMetaData prime : list) {
            List<ResourceMetaData> matched = SubsystemPlan.findPartition(partitions, prime);
            if (matched == null) {
                matched = new ArrayList<ResourceMetaData>();
                partitions.add(matched);
            }
            matched.add(prime);
        }
        return partitions;
    }

    static List<ResourceMetaData> findPartition(List<List<ResourceMetaData>> partitions, ResourceMetaData prime) {
        for (List<ResourceMetaData> partition : partitions) {
            boolean match;
            if (partition.isEmpty()) continue;
            ResourceMetaData comp = partition.get(0);
            ResourceDescription compDesc = comp.getDescription();
            ResourceDescription primeDesc = prime.getDescription();
            if (compDesc.getAttributes().size() != primeDesc.getAttributes().size() || !(match = compDesc.getAttributes().stream().allMatch(c -> {
                boolean found = primeDesc.getAttributes().stream().anyMatch(p -> {
                    if (!p.getName().equals(c.getName())) {
                        return false;
                    }
                    return p.getValue().getType().equals((Object)c.getValue().getType());
                });
                return found;
            })) || !(match = compDesc.getChildrenTypes().equals(primeDesc.getChildrenTypes())) || !(match = compDesc.getSingletonChildrenTypes().equals(primeDesc.getSingletonChildrenTypes()))) continue;
            return partition;
        }
        return null;
    }

    static List<List<EnumRequirement>> partitionEnumRequirements(List<EnumRequirement> list) {
        ArrayList<List<EnumRequirement>> partitions = new ArrayList<List<EnumRequirement>>();
        for (EnumRequirement prime : list) {
            List<EnumRequirement> matched = SubsystemPlan.findEnumRequirementPartition(partitions, prime);
            if (matched == null) {
                matched = new ArrayList<EnumRequirement>();
                partitions.add(matched);
            }
            matched.add(prime);
        }
        return partitions;
    }

    static List<EnumRequirement> findEnumRequirementPartition(List<List<EnumRequirement>> partitions, EnumRequirement prime) {
        for (List<EnumRequirement> partition : partitions) {
            if (partition.isEmpty()) continue;
            EnumRequirement comp = partition.get(0);
            if (!prime.getName().equals(comp.getName()) || !prime.getAllowedValues().equals(comp.getAllowedValues())) continue;
            return partition;
        }
        return null;
    }

    static void collect(ResourceMetaData root, List<ResourceMetaData> list) {
        Set<String> childTypes = root.getDescription().getChildrenTypes();
        for (String childType : childTypes) {
            ResourceDescription child = root.getDescription().getChildDescription(childType);
            ResourceMetaData childMeta = new ResourceMetaData(root.getAddress().append(childType + "=*"), child);
            list.add(childMeta);
            SubsystemPlan.collect(childMeta, list);
        }
        Set<String> singletonTypes = root.getDescription().getSingletonChildrenTypes();
        for (String childType : singletonTypes) {
            String[] parts = childType.split("=");
            ResourceDescription child = root.getDescription().getChildDescription(parts[0], parts[1]);
            child.setSingletonName(parts[1]);
            ResourceMetaData childMeta = new ResourceMetaData(root.getAddress().append(childType), child);
            list.add(childMeta);
            SubsystemPlan.collect(childMeta, list);
        }
    }
}

