/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.wildfly.swarm.config.generator.generator.GeneratorTarget;

public class Config {
    private JsonObject json;

    public Config(JsonObject json) {
        this.json = json;
    }

    public List<GeneratorTarget> getGeneratorTargets() {
        ArrayList<GeneratorTarget> references = new ArrayList<GeneratorTarget>();
        this.json.get("generatorTargets").asArray().forEach(ref -> references.add(new GeneratorTarget(ref.asString())));
        return references;
    }

    public String getModuleName() {
        return this.json.getString("module", "unkonwn");
    }

    public Path getModulePath() {
        StringTokenizer tokens = new StringTokenizer(this.getModuleName(), ".");
        Path path = null;
        while (tokens.hasMoreTokens()) {
            if (path == null) {
                path = Paths.get(tokens.nextToken(), new String[0]);
                continue;
            }
            path = path.resolve(tokens.nextToken());
        }
        return path;
    }

    public Path getModulePath(String slot) {
        return this.getModulePath().resolve(Paths.get(slot, "module.xml"));
    }

    public String getUser() {
        JsonObject server = this.json.get("server").asObject();
        return server.get("user").asString();
    }

    public String getPass() {
        JsonObject server = this.json.get("server").asObject();
        return server.get("pass").asString();
    }

    public int getPort() {
        JsonObject server = this.json.get("server").asObject();
        return server.get("port").asInt();
    }

    public String getHost() {
        JsonObject server = this.json.get("server").asObject();
        return server.get("host").asString();
    }

    public static Config fromJson(String filename) throws Exception {
        return new Config(Json.parse((Reader)new FileReader(filename)).asObject());
    }
}

