/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.generator.generator;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.swarm.config.generator.generator.ClassPlan;
import org.wildfly.swarm.config.generator.generator.EnumRequirement;

public class EnumPlan
implements Comparable<EnumPlan> {
    private final List<EnumRequirement> requirements;
    private String packageName;
    private String className;

    public EnumPlan(String subsystemPackage, List<EnumRequirement> requirements) {
        this.requirements = requirements;
        if (subsystemPackage != null) {
            this.packageName = subsystemPackage;
            for (EnumRequirement requirement : this.requirements) {
                String candidate = requirement.getOriginatingClassPlan().getPackageName();
                if (candidate.length() <= subsystemPackage.length() || candidate.length() >= this.packageName.length()) continue;
                this.packageName = candidate;
            }
        }
        this.className = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, requirements.get(0).getName());
    }

    public List<ClassPlan> getOriginatingClassPlans() {
        return this.requirements.stream().map(e -> e.getOriginatingClassPlan()).collect(Collectors.toList());
    }

    public boolean matches(ClassPlan requester, Property attr) {
        return this.requirements.stream().anyMatch(e -> e.getOriginatingClassPlan() == requester && e.getProperty().getName().equals(attr.getName()));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    public List<ModelNode> getAllowedValues() {
        return this.requirements.get(0).getValue().get("allowed").asList();
    }

    public String toString() {
        return this.requirements.get(0).getName() + " (" + this.requirements.size() + ") -> " + this.getAllowedValues();
    }

    @Override
    public int compareTo(EnumPlan o) {
        return this.getFullyQualifiedClassName().compareTo(o.getFullyQualifiedClassName());
    }
}

