/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.StaticContentClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StaticContentClient.Heading", generator="Immutables")
@Immutable
public final class ImmutableHeading
implements StaticContentClient.Heading {
    private final Integer order;
    private final Integer level;
    private final String name;

    private ImmutableHeading(Integer order, Integer level, String name) {
        this.order = order;
        this.level = level;
        this.name = name;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public Integer getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final ImmutableHeading withOrder(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "order");
        if (this.order.equals(newValue)) {
            return this;
        }
        return new ImmutableHeading(newValue, this.level, this.name);
    }

    public final ImmutableHeading withLevel(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "level");
        if (this.level.equals(newValue)) {
            return this;
        }
        return new ImmutableHeading(this.order, newValue, this.name);
    }

    public final ImmutableHeading withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableHeading(this.order, this.level, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHeading && this.equalTo((ImmutableHeading)another);
    }

    private boolean equalTo(ImmutableHeading another) {
        return this.order.equals(another.order) && this.level.equals(another.level) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.order.hashCode();
        h += (h << 5) + this.level.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Heading").omitNullValues().add("order", (Object)this.order).add("level", (Object)this.level).add("name", (Object)this.name).toString();
    }

    public static ImmutableHeading copyOf(StaticContentClient.Heading instance) {
        if (instance instanceof ImmutableHeading) {
            return (ImmutableHeading)instance;
        }
        return ImmutableHeading.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StaticContentClient.Heading", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ORDER = 1L;
        private static final long INIT_BIT_LEVEL = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private Integer order;
        @Nullable
        private Integer level;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StaticContentClient.Heading instance) {
            Objects.requireNonNull(instance, "instance");
            this.order(instance.getOrder());
            this.level(instance.getLevel());
            this.name(instance.getName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder order(Integer order) {
            this.order = Objects.requireNonNull(order, "order");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder level(Integer level) {
            this.level = Objects.requireNonNull(level, "level");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableHeading build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHeading(this.order, this.level, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("order");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("level");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Heading, some of required attributes are not set " + attributes;
        }
    }
}

