package io.thestencil.staticontent.spi.visitor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SiteVisitor.TopicNameData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTopicNameData.builder()}.
 */
@Generated(from = "SiteVisitor.TopicNameData", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTopicNameData
    implements SiteVisitor.TopicNameData {
  private final String path;
  private final ImmutableMap<String, String> locale;

  private ImmutableTopicNameData(
      String path,
      ImmutableMap<String, String> locale) {
    this.path = path;
    this.locale = locale;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public ImmutableMap<String, String> getLocale() {
    return locale;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SiteVisitor.TopicNameData#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTopicNameData withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableTopicNameData(newValue, this.locale);
  }

  /**
   * Copy the current immutable object by replacing the {@link SiteVisitor.TopicNameData#getLocale() locale} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the locale map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicNameData withLocale(Map<String, ? extends String> entries) {
    if (this.locale == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableTopicNameData(this.path, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTopicNameData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTopicNameData
        && equalTo((ImmutableTopicNameData) another);
  }

  private boolean equalTo(ImmutableTopicNameData another) {
    return path.equals(another.path)
        && locale.equals(another.locale);
  }

  /**
   * Computes a hash code from attributes: {@code path}, {@code locale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + path.hashCode();
    h += (h << 5) + locale.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TopicNameData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TopicNameData")
        .omitNullValues()
        .add("path", path)
        .add("locale", locale)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SiteVisitor.TopicNameData} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TopicNameData instance
   */
  public static ImmutableTopicNameData copyOf(SiteVisitor.TopicNameData instance) {
    if (instance instanceof ImmutableTopicNameData) {
      return (ImmutableTopicNameData) instance;
    }
    return ImmutableTopicNameData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTopicNameData ImmutableTopicNameData}.
   * <pre>
   * ImmutableTopicNameData.builder()
   *    .path(String) // required {@link SiteVisitor.TopicNameData#getPath() path}
   *    .putLocale|putAllLocale(String =&gt; String) // {@link SiteVisitor.TopicNameData#getLocale() locale} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableTopicNameData builder
   */
  public static ImmutableTopicNameData.Builder builder() {
    return new ImmutableTopicNameData.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTopicNameData ImmutableTopicNameData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SiteVisitor.TopicNameData", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String path;
    private ImmutableMap.Builder<String, String> locale = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TopicNameData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SiteVisitor.TopicNameData instance) {
      Objects.requireNonNull(instance, "instance");
      path(instance.getPath());
      putAllLocale(instance.getLocale());
      return this;
    }

    /**
     * Initializes the value for the {@link SiteVisitor.TopicNameData#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Put one entry to the {@link SiteVisitor.TopicNameData#getLocale() locale} map.
     * @param key The key in the locale map
     * @param value The associated value in the locale map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putLocale(String key, String value) {
      this.locale.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SiteVisitor.TopicNameData#getLocale() locale} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putLocale(Map.Entry<String, ? extends String> entry) {
      this.locale.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SiteVisitor.TopicNameData#getLocale() locale} map. Nulls are not permitted
     * @param entries The entries that will be added to the locale map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locale(Map<String, ? extends String> entries) {
      this.locale = ImmutableMap.builder();
      return putAllLocale(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SiteVisitor.TopicNameData#getLocale() locale} map. Nulls are not permitted
     * @param entries The entries that will be added to the locale map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllLocale(Map<String, ? extends String> entries) {
      this.locale.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTopicNameData ImmutableTopicNameData}.
     * @return An immutable instance of TopicNameData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTopicNameData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTopicNameData(path, locale.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      return "Cannot build TopicNameData, some of required attributes are not set " + attributes;
    }
  }
}
